/**
*   MOD3 3D Modifier Library for JavaScript
*   port of AS3DMod ActionScript3 library (http://code.google.com/p/as3dmod/)
*
*   @version 1.0.0 (2023-01-03 16:08:34)
*   https://github.com/foo123/MOD3
*
**/!function(n,t,e){"use strict";"object"==typeof module&&module.exports?(module.$deps=module.$deps||{})&&(module.exports=module.$deps[t]=e.call(n)):"function"==typeof define&&define.amd&&"function"==typeof require&&"function"==typeof require.specified&&require.specified(t)?define(t,["module"],function(t){return e.moduleUri=t.uri,e.call(n)}):t in n||(n[t]=e.call(n)||1)&&"function"==typeof define&&define.amd&&define(function(){return n[t]})}("undefined"!=typeof self?self:this,"MOD3",function(){"use strict";var a=Object.prototype.hasOwnProperty,t=Object.prototype.toString,d=(Object.defineProperty,Math),n=d.PI,e=2*n,r=n/2,i=1/n,u=function(){};"undefined"!=typeof global&&t.call(global),"undefined"!=typeof window&&t.call(window);var y={VERSION:"1.0.0",Class:function(t,n,e){arguments.length<2&&(n=t,t=null);var r,i,o,s=a.call(n,"constructor")?n.constructor:function(){};for(r in t?(s.prototype=Object.create(t.prototype),s.prototype.$super=(i=t,o={},function(t,n){var e=":"+t;return 1===o[e]?(i.prototype.$super||u).call(this,t,n):(o[e]=1,n=("constructor"===t?i:i.prototype[t]||u).apply(this,n||[]),o[e]=0,n)})):s.prototype.$super=u,s.prototype.constructor=s,n)a.call(n,r)&&"constructor"!==r&&(s.prototype[r]=n[r]);if(e)for(r in e)a.call(e,r)&&(s[r]=e[r]);return s}};function o(t){t.dispose()}function s(t){t.reset()}function l(t){t.collapse()}y.Constants={PI:n,invPI:i,halfPI:r,doublePI:e,toRad:n/180,toDeg:180/n},y.ModConstant={NONE:0,LEFT:-1,RIGHT:1,X:1,Y:2,Z:4,Xi:0,Yi:1,Zi:2},y.XYZi=[null,0,1,null,2],y.iXYZ=[1,2,4],y.xyz=["x","y","z"],y.XYZ=["X","Y","Z"],y.Array32F="undefined"!=typeof Float32Array?Float32Array:Array,y.Array64F="undefined"!=typeof Float64Array?Float64Array:Array,y.Array8I="undefined"!=typeof Int8Array?Int8Array:Array,y.Array16I="undefined"!=typeof Int16Array?Int16Array:Array,y.Array32I="undefined"!=typeof Int32Array?Int32Array:Array,y.Array8U="undefined"!=typeof Uint8Array?Uint8Array:Array,y.Array16U="undefined"!=typeof Uint16Array?Uint16Array:Array,y.Array32U="undefined"!=typeof Uint32Array?Uint32Array:Array,y.VecArray=y.Array32F,y.XMath={normalize:function(t,n,e){return 0==n-t?1:y.XMath.trim(0,1,(e-t)/n)},toRange:function(t,n,e){n-=t;return 0==n?0:t+n*e},inRange:function(t,n,e,r){return!1!==r?t<=e&&e<=n:t<e&&e<n},sign:function(t,n){return 0===t?n||0:0<t?1:-1},trim:function(t,n,e){return e<t?t:n<e?n:e},wrap:function(t,n,e){var r=n-t;return e<t?e+r:n<=e?e-r:e},degToRad:function(t){return t/180*n},radToDeg:function(t){return t/n*180},presicion:function(t,n){n=d.pow(10,n);return d.round(t*n)/n},uceil:function(t){return t<0?d.floor(t):d.ceil(t)}},y.XMath.clamp=y.XMath.trim,y.Range=y.Class({constructor:function t(n,e){if(!(this instanceof t))return new t(n,e);this.start=null!=n?n:0,this.end=null!=e?e:1},name:"Range",start:0,end:1,dispose:function(){return this.start=null,this.end=null,this},getSize:function(){return this.end-this.start},move:function(t){this.start+=t,this.end+=t},isIn:function(t){return t>=this.start&&t<=this.end},normalize:function(t){return y.XMath.normalize(this.start,this.end,t)},toRange:function(t){return y.XMath.toRange(this.start,this.end,t)},trim:function(t){return y.XMath.trim(this.start,this.end,t)},interpolate:function(t,n){return y.XMath.toRange(this.start,this.end,n.normalize(t))},toString:function(){return"["+this.start+" - "+this.end+"]"}}),y.Phase=y.Class({constructor:function t(n){if(!(this instanceof t))return new t(n);this.value=n||0},name:"Phase",value:0,dispose:function(){return this.value=null,this},getPhasedValue:function(){return d.sin(this.value)},getAbsPhasedValue:function(){return d.abs(d.sin(this.value))},getNormValue:function(){return.5*(d.sin(this.value)+1)}}),y.Point=y.Class({constructor:function t(n,e){if(!(this instanceof t))return new t(n,e);this.x=n||0,this.y=e||0},name:"Point",x:0,y:0,dispose:function(){return this.x=null,this.y=null,this},clone:function(){return new y.Point(this.x,this.y)}}),y.Matrix=y.Class(null,{constructor:function t(n,e,r,i){if(!(this instanceof t))return new t(n,e,r,i);this.m=new y.VecArray([null==n?1:n,null==e?0:e,null==r?0:r,null==i?1:i])},name:"Matrix",m:null,dispose:function(){return this.m=null,this},reset:function(){var t=this.m;return t[0]=1,t[1]=0,t[2]=0,t[3]=1,this},rotate:function(t){var n=this.m,e=d.cos(t),t=d.sin(t);return n[0]=e,n[1]=-t,n[2]=t,n[3]=e,this},scale:function(t,n){var e=this.m;return e[0]=1,e[1]=0,e[2]=0,e[3]=1,null!=t&&(e[0]=t,e[3]=t),null!=n&&(e[3]=n),this},multiply:function(t){return y.Matrix.mult(this,t)},transformPoint:function(t){t=y.Matrix.transform(this,[t.x,t.y]);return new y.Point(t[0],t[1])},transformPointSelf:function(t){var n=y.Matrix.transform(this,[t.x,t.y]);return t.x=n[0],t.y=n[1],t},clone:function(){var t=this.m;return new y.Matrix(t[0],t[1],t[2],t[3])}},{transform:function(t,n){var e=t.m,r=n[0],t=n[1];return n[0]=e[0]*r+e[1]*t,n[1]=e[2]*r+e[3]*t,n},mult:function(t,n){var e=t.m,r=n.m,i=e[0],o=e[1],s=e[2],n=e[3];return e[0]=i*r[0]+o*r[2],e[1]=i*r[1]+o*r[3],e[2]=s*r[0]+n*r[2],e[3]=s*r[1]+n*r[3],t}}),y.Vector3=y.Class(null,{constructor:function t(n,e,r){if(!(this instanceof t))return new t(n,e,r);var i=new y.VecArray(3);n&&3===n.length?(i[0]=n[0]||0,i[1]=n[1]||0,i[2]=n[2]||0):(i[0]=n||0,i[1]=e||0,i[2]=r||0),this.xyz=i},name:"Vector3",xyz:null,dispose:function(){return this.xyz=null,this},getXYZ:function(){return new y.VecArray(this.xyz)},getXYZRef:function(){return this.xyz},setXYZ:function(t){var n=this.xyz;return n[0]=t[0],n[1]=t[1],n[2]=t[2],this},setXYZRef:function(t){return this.xyz=t,this},clone:function(){return new y.Vector3(this.xyz)},equalsSelf:function(t){var n=this.xyz,t=t.xyz;return n[0]===t[0]&&n[1]===t[1]&&n[2]===t[2]},zeroSelf:function(){var t=this.xyz;return t[0]=0,t[1]=0,t[2]=0,this},negate:function(){var t=this.xyz;return new y.Vector3(-t[0],-t[1],-t[2])},negateSelf:function(){var t=this.xyz;return t[0]=-t[0],t[1]=-t[1],t[2]=-t[2],this},add:function(t){var n=this.xyz,t=t.xyz;return new y.Vector3(n[0]+t[0],n[1]+t[1],n[2]+t[2])},addSelf:function(t){var n=this.xyz,t=t.xyz;return n[0]+=t[0],n[1]+=t[1],n[2]+=t[2],this},subtract:function(t){var n=this.xyz,t=t.xyz;return new y.Vector3(n[0]-t[0],n[1]-t[1],n[2]-t[2])},subtractSelf:function(t){var n=this.xyz,t=t.xyz;return n[0]-=t[0],n[1]-=t[1],n[2]-=t[2],this},multiplyScalar:function(t){var n=this.xyz;return new y.Vector3(n[0]*t,n[1]*t,n[2]*t)},multiplyScalarSelf:function(t){var n=this.xyz;return n[0]*=t,n[1]*=t,n[2]*=t,this},multiply:function(t){var n=this.xyz,t=t.xyz;return new y.Vector3(n[0]*t[0],n[1]*t[1],n[2]*t[2])},multiplySelf:function(t){var n=this.xyz,t=t.xyz;return n[0]*=t[0],n[1]*=t[1],n[2]*=t[2],this},divide:function(t){var n=this.xyz;return new y.Vector3(n[0]/t,n[1]/t,n[2]/t)},divideSelf:function(t){var n=this.xyz;return n[0]/=t,n[1]/=t,n[2]/=t,this},normalize:function(){var t=this.xyz,n=t[0],e=t[1],r=t[2],t=n*n+e*e+r*r;return 0<t&&(n/=t=d.sqrt(t),e/=t,r/=t),new y.Vector3(n,e,r)},normalizeSelf:function(){var t=this.xyz,n=t[0],e=t[1],r=t[2],i=n*n+e*e+r*r;return 0<i&&(n/=i=d.sqrt(i),e/=i,r/=i),t[0]=n,t[1]=e,t[2]=r,this},getMagnitude:function(){var t=this.xyz,n=t[0],e=t[1],t=t[2];return d.sqrt(n*n+e*e+t*t)},setMagnitude:function(t){this.normalizeSelf();var n=this.xyz;return n[0]*=t,n[1]*=t,n[2]*=t,this},dot:function(t){var n=this.xyz,t=t.xyz;return n[0]*t[0]+n[1]*t[1]+n[2]*t[2]},cross:function(t){var n=this.xyz,e=t.xyz,r=n[0],i=n[1],o=n[2],t=e[0],n=e[1],e=e[2];return new y.Vector3(i*e-o*n,o*t-r*e,r*n-i*t)},crossSelf:function(t){var t=this.xyz,n=b.xyz,e=t[0],r=t[1],i=t[2],o=n[0],s=n[1],n=n[2];return t[0]=r*n-i*s,t[1]=i*o-e*n,t[2]=e*s-r*o,this},distance:function(t){var n=this.xyz,e=t.xyz,r=n[0]-e[0],t=n[1]-e[1],e=n[2]-e[2];return d.sqrt(r*r+t*t+e*e)},toString:function(){var t=this.xyz;return"["+t[0]+" , "+t[1]+" , "+t[2]+"]"}},{ZERO:function(){return new y.Vector3(0,0,0)},X:function(t){return!1===t?new y.Vector3(0,1,1):new y.Vector3(1,0,0)},Y:function(t){return!1===t?new y.Vector3(1,0,1):new y.Vector3(0,1,0)},Z:function(t){return!1===t?new y.Vector3(1,1,0):new y.Vector3(0,0,1)},dot:function(t,n){return t[0]*n[0]+t[1]*n[1]+t[2]*n[2]},equals:function(t,n){return t[0]===n[0]&&t[1]===n[1]&&t[2]===n[2]},cross:function(t,n){var e=new y.VecArray(3);return e[0]=t[1]*n[2]-t[2]*n[1],e[1]=t[2]*n[0]-t[0]*n[2],e[2]=t[0]*n[1]-t[1]*n[0],e},mod:function(t){var n=t[0],e=t[1],t=t[2];return d.sqrt(n*n+e*e+t*t)},dist:function(t,n){var e=t[0]-n[0],r=t[1]-n[1],n=t[2]-n[2];return d.sqrt(e*e+r*r+n*n)},add:function(t,n){return t[0]+=n[0],t[1]+=n[1],t[2]+=n[2],t},sub:function(t,n){return t[0]-=n[0],t[1]-=n[1],t[2]-=n[2],t},mul:function(t,n){return t[0]*=n[0],t[1]*=n[1],t[2]*=n[2],t},muls:function(t,n){return t[0]*=n,t[1]*=n,t[2]*=n,t},norm:function(t){var n=t[0],e=t[1],r=t[2],i=n*n+e*e+r*r;return 0<i&&(n/=i=d.sqrt(i),e/=i,r/=i),t[0]=n,t[1]=e,t[2]=r,t}}),y.Vector3.modulo=y.Vector3.mod,y.Vector3.distance=y.Vector3.dist,y.Vector3.prototype.dotSelf=y.Vector3.prototype.dot,y.Vector3.prototype.distanceSelf=y.Vector3.prototype.distance,y.Matrix4=y.Class(null,{constructor:function t(n,e,r,i,o,s,a,u,l,c,f,h,d,p,m,x){if(!(this instanceof t))return new t(n,e,r,i,o,s,a,u,l,c,f,h,d,p,m,x);this.m=new y.VecArray([null==n?1:n,null==e?0:e,null==r?0:r,null==i?0:i,null==o?0:o,null==s?1:s,null==a?0:a,null==u?0:u,null==l?0:l,null==c?0:c,null==f?1:f,null==h?0:h,null==d?0:d,null==p?0:p,null==m?0:m,null==x?1:x])},name:"Matrix4",m:null,dispose:function(){return this.m=null,this},reset:function(){var t=this.m;return t[0]=1,t[1]=0,t[2]=0,t[3]=0,t[4]=0,t[5]=1,t[6]=0,t[7]=0,t[8]=0,t[9]=0,t[10]=1,t[11]=0,t[12]=0,t[13]=0,t[14]=0,t[15]=1,this},translate:function(t,n,e,r){var i=this.m;return!0===r&&this.reset(),i[3]=t,i[7]=n,i[11]=e,this},scale:function(t,n,e,r){var i=this.m;return!0===r&&this.reset(),i[0]=t,i[5]=n,i[10]=e,this},rotate:function(t,n,e,r,i){var o=this.m,s=d.cos(r),a=d.sin(r),u=1-s,l=t*n*u,c=n*e*u,f=t*e*u,h=a*e,r=a*n,a=a*t;return!0===i&&this.reset(),o[0]=s+t*t*u,o[1]=l-h,o[2]=r+f,o[3]=0,o[4]=h+l,o[5]=s+n*n*u,o[6]=c-a,o[7]=0,o[8]=f-r,o[9]=a+c,o[10]=s+e*e*u,o[11]=0,this},translateFromVector:function(t,n){return this.translate(t.xyz[0],t.xyz[1],t.xyz[2],n)},scaleFromVector:function(t,n){return this.scale(t.xyz[0],t.xyz[1],t.xyz[2],n)},rotateFromVector:function(t,n,e){return this.rotate(t.xyz[0],t.xyz[1],t.xyz[2],n,e)},multiply:function(t){return y.Matrix4.mult(this,t)},multiplyVector:function(t){return y.Matrix4.multXYZ(this,t.xyz),t}},{multXYZ:function(t,n){var e=t.m,r=n[0],i=n[1],t=n[2];return n[0]=r*e[0]+i*e[1]+t*e[2]+e[3],n[1]=r*e[4]+i*e[5]+t*e[6]+e[7],n[2]=r*e[8]+i*e[9]+t*e[10]+e[11],n},mult:function(t,n){var e=t.m,r=n.m,i=e[0],o=r[0],s=e[4],a=r[4],u=e[8],l=r[8],c=e[1],f=r[1],h=e[5],d=r[5],p=e[9],m=r[9],x=e[2],y=r[2],M=e[6],v=r[6],g=e[10],w=r[10],V=e[3],X=r[3],Y=e[7],A=r[7],n=e[11],r=r[11];return e[0]=i*o+c*a+x*l,e[1]=i*f+c*d+x*m,e[2]=i*y+c*v+x*w,e[3]=i*X+c*A+x*r+V,e[4]=s*o+h*a+M*l,e[5]=s*f+h*d+M*m,e[6]=s*y+h*v+M*w,e[7]=s*X+h*A+M*r+Y,e[8]=u*o+p*a+g*l,e[9]=u*f+p*d+g*m,e[10]=u*y+p*v+g*w,e[11]=u*X+p*A+g*r+n,t}}),y.Matrix4.prototype.translationMatrix=y.Matrix4.prototype.translate,y.Matrix4.prototype.scaleMatrix=y.Matrix4.prototype.scale,y.Matrix4.prototype.rotationMatrix=y.Matrix4.prototype.rotate,y.Matrix4.prototype.translationMatrixFromVector=y.Matrix4.prototype.translateFromVector,y.Matrix4.prototype.scaleMatrixFromVector=y.Matrix4.prototype.scaleFromVector,y.Matrix4.prototype.rotationMatrixFromVector=y.Matrix4.prototype.rotateFromVector,y.List={operate:function(t,n,e,r,i,o){var s=t.length;if(arguments.length<5&&(i=s-1),i<0&&(i+=s),arguments.length<4&&(r=0),i<r)return e;if(!0===o){var o=(f=i-r+1)-1,a=o-(h=15&f),u=(d=1&h)?n(e,t[i],i):e;for(l=o-d;a<l;l-=2)u=n(n(u,t[c=r+l],c),t[c-1],c-1);for(l=a;0<=l;l-=16)u=n(n(n(n(n(n(n(n(n(n(n(n(n(n(n(n(u,t[c=r+l],c),t[c-1],c-1),t[c-2],c-2),t[c-3],c-3),t[c-4],c-4),t[c-5],c-5),t[c-6],c-6),t[c-7],c-7),t[c-8],c-8),t[c-9],c-9),t[c-10],c-10),t[c-11],c-11),t[c-12],c-12),t[c-13],c-13),t[c-14],c-14),t[c-15],c-15)}else{var l,c,f,h,d,u=(d=1&(h=15&(f=i-r+1)))?n(e,t[r],r):e;for(l=d;l<h;l+=2)u=n(n(u,t[c=r+l],c),t[c+1],c+1);for(l=h;l<f;l+=16)u=n(n(n(n(n(n(n(n(n(n(n(n(n(n(n(n(u,t[c=r+l],c),t[c+1],c+1),t[c+2],c+2),t[c+3],c+3),t[c+4],c+4),t[c+5],c+5),t[c+6],c+6),t[c+7],c+7),t[c+8],c+8),t[c+9],c+9),t[c+10],c+10),t[c+11],c+11),t[c+12],c+12),t[c+13],c+13),t[c+14],c+14),t[c+15],c+15)}return u},each:function(t,n,e,r,i){if(null==t||!t.length)return t;var o=t.length;if(arguments.length<4&&(r=o-1),r<0&&(r+=o),arguments.length<3&&(e=0),r<e)return t;var s,a,u,l,c,f=r-e+1;if(!0===i){for(u=(i=f-1)-(l=15&f),(c=1&l)&&n(t[r]),s=i-c;u<s;s-=2)n(t[a=e+s]),n(t[a-1]);for(s=u;0<=s;s-=16)n(t[a=e+s]),n(t[a-1]),n(t[a-2]),n(t[a-3]),n(t[a-4]),n(t[a-5]),n(t[a-6]),n(t[a-7]),n(t[a-8]),n(t[a-9]),n(t[a-10]),n(t[a-11]),n(t[a-12]),n(t[a-13]),n(t[a-14]),n(t[a-15])}else{for((c=1&(l=15&f))&&n(t[e]),s=c;s<l;s+=2)n(t[a=e+s]),n(t[a+1]);for(s=l;s<f;s+=16)n(t[a=e+s]),n(t[a+1]),n(t[a+2]),n(t[a+3]),n(t[a+4]),n(t[a+5]),n(t[a+6]),n(t[a+7]),n(t[a+8]),n(t[a+9]),n(t[a+10]),n(t[a+11]),n(t[a+12]),n(t[a+13]),n(t[a+14]),n(t[a+15])}return t}},y.FaceProxy=y.Class(null,{constructor:function(){this.vertices=[]},name:"FaceProxy",vertices:null,dispose:function(){return this.vertices=null,this},addVertex:function(t){this.vertices.push(t)},getVertices:function(){return this.vertices}}),y.VertexProxy=y.Class(null,{constructor:function(t,n){this.mesh=n||null,this.original=new y.VecArray([0,0,0]),this.ratio=new y.VecArray([0,0,0]),null!=t&&this.setVertex(t)},name:"VertexProxy",mesh:null,vertex:null,original:null,ratio:null,dispose:function(){var t=this;return t.mesh=null,t.vertex=null,t.original=null,t.ratio=null,t},setVertex:function(t){return this.vertex=t,this},getRatioVector:function(){var t=this.ratio,n=new y.VecArray(3);return n[0]=t[0],n[1]=t[1],n[2]=t[2],n},getRatio:function(t){return this.ratio[y.XYZi[t]]||0},setRatios:function(t,n,e){var r=this.ratio;return r[0]=t||0,r[1]=n||0,r[2]=e||0,this},getOriginalValue:function(t){return this.original[y.XYZi[t]]||0},setOriginalPosition:function(t,n,e){var r=this.original;return r[0]=t||0,r[1]=n||0,r[2]=e||0,this},getXYZ:function(){return new y.VecArray([0,0,0])},getX:function(){return 0},getY:function(){return 0},getZ:function(){return 0},getValue:function(t){return y.ModConstant.X===t?this.getX():y.ModConstant.Y===t?this.getY():y.ModConstant.Z===t?this.getZ():0},setXYZ:function(t){return this},setX:function(t){return this},setY:function(t){return this},setZ:function(t){return this},setValue:function(t,n){return y.ModConstant.X===t?this.setX(n):y.ModConstant.Y===t?this.setY(n):y.ModConstant.Z===t&&this.setZ(n),this},reset:function(){return this.setXYZ(this.original),this},collapse:function(){var t=this.getXYZ(),n=this.original;return n[0]=t[0],n[1]=t[1],n[2]=t[2],this}}),y.MeshProxy=y.Class(null,{constructor:function(t){var n=this;n.maxX=0,n.maxY=0,n.maxZ=0,n.minX=0,n.minY=0,n.minZ=0,n.maxAxis=0,n.midAxis=0,n.minAxis=0,n.width=0,n.height=0,n.depth=0,n.vertices=null,n.faces=null,(n.mesh=null)!=t&&n.setMesh(t)},name:"MeshProxy",maxX:0,maxY:0,maxZ:0,minX:0,minY:0,minZ:0,maxAxis:0,midAxis:0,minAxis:0,width:0,height:0,depth:0,vertices:null,faces:null,mesh:null,v:null,dispose:function(){var t=this;return t.maxX=null,t.maxY=null,t.maxZ=null,t.minX=null,t.minY=null,t.minZ=null,t.maxAxis=null,t.midAxis=null,t.minAxis=null,t.width=null,t.height=null,t.depth=null,t.disposeFaces(),t.disposeVertices(),t.mesh=null,t.v=null,t},disposeVertices:function(){return this.vertices&&y.List.each(this.vertices,o),this.vertices=null,this},disposeFaces:function(){return this.faces&&y.List.each(this.faces,o),this.faces=null,this},init:function(t){return this.mesh=t,this},setMesh:function(t){var n=this;return n.init(t),n.preApply(),n.analyzeGeometry(),n.postApply(),n},getVertices:function(){return this.vertices},getFaces:function(){return this.faces},applyModifiers:function(t){for(var n=0,e=t.length;n<e;++n)t[n].enabled&&t[n].apply(this);return this},analyzeGeometry:function(){var e,r,i,t,n,o=this,s=o.vertices,a=0,u=0,l=0,c=0,f=0,h=0;return s&&s.length&&(n=s[0].getXYZ(),a=n[0],u=n[1],l=n[2],c=n[0],f=n[1],h=n[2],y.List.each(s,function(t){var n=t.getXYZ(),e=n[0],r=n[1],n=n[2];a=d.min(a,e),u=d.min(u,r),l=d.min(l,n),c=d.max(c,e),f=d.max(f,r),h=d.max(h,n),t.setOriginalPosition(e,r,n)}),e=c-a,r=f-u,i=h-l,o.width=e,o.height=r,o.depth=i,o.minX=a,o.maxX=c,o.minY=u,o.maxY=f,o.minZ=l,o.maxZ=h,t=d.max(e,r,i),n=d.min(e,r,i),t===e&&n===r?(o.minAxis=y.ModConstant.Y,o.midAxis=y.ModConstant.Z,o.maxAxis=y.ModConstant.X):t===e&&n===i?(o.minAxis=y.ModConstant.Z,o.midAxis=y.ModConstant.Y,o.maxAxis=y.ModConstant.X):t===r&&n===e?(o.minAxis=y.ModConstant.X,o.midAxis=y.ModConstant.Z,o.maxAxis=y.ModConstant.Y):t===r&&n===i?(o.minAxis=y.ModConstant.Z,o.midAxis=y.ModConstant.X,o.maxAxis=y.ModConstant.Y):t===i&&n===e?(o.minAxis=y.ModConstant.X,o.midAxis=y.ModConstant.Y,o.maxAxis=y.ModConstant.Z):t===i&&n===r&&(o.minAxis=y.ModConstant.Y,o.midAxis=y.ModConstant.X,o.maxAxis=y.ModConstant.Z),y.List.each(s,function(t){var n=t.getXYZ();t.setRatios(0<e?(n[0]-a)/e:0,0<r?(n[1]-u)/r:0,0<i?(n[2]-l)/i:0)})),o},resetGeometry:function(){return y.List.each(this.vertices,s),this},collapseGeometry:function(){return y.List.each(this.vertices,l),this.analyzeGeometry(),this},getMin:function(t){return y.ModConstant.X===t?this.minX:y.ModConstant.Y===t?this.minY:y.ModConstant.Z===t?this.minZ:-1},getMax:function(t){return y.ModConstant.X===t?this.maxX:y.ModConstant.Y===t?this.maxY:y.ModConstant.Z===t?this.maxZ:-1},getSize:function(t){return y.ModConstant.X===t?this.width:y.ModConstant.Y===t?this.height:y.ModConstant.Z===t?this.depth:-1},update:function(){return this},preApply:function(){return this},postApply:function(){return this},updateMeshPosition:function(t){return this}}),y.Library3d={id:"Library3d",Mesh:y.MeshProxy,Vertex:y.VertexProxy},y.Factory={getLibrary:function(t){return t&&t.library&&y[t.library]?y[t.library]:y.Library3d},getMeshProxy:function(t){return arguments.length&&t.Mesh?new t.Mesh:null},getModifier:function(t){return t&&t.modifier&&y[t.modifier]?new y[t.modifier]:null}};var c,v,g,w,V,X,f,h,p,m,x,M,Y,A,Z,C,z,S,P,F,R=0;return y.Modifier=y.Class({constructor:function(){var t=this;t.id=++R,t.name="Modifier",t.axes=y.ModConstant.NONE,t.constraint=y.ModConstant.NONE,t.enabled=!0},id:null,name:"Modifier",axes:null,constraint:null,enabled:!0,dispose:function(){return this.name=null,this.axes=null,this.constraint=null,this},enable:function(t){return arguments.length?(this.enabled=!!t,this):this.enabled},constraintAxes:function(t){return this.axes=t||y.ModConstant.NONE,this},setConstraint:function(t){return this.constraint=t||y.ModConstant.NONE,this},apply:function(t){return this},toString:function(){return"[Modifier "+this.name+"]"}}),y.ModifierStack=y.Class({constructor:function t(n,e){if(!(this instanceof t))return new t(n,e);this.stack=[],this.setModifiable(y.Factory.getMeshProxy(n),e)},name:"ModifierStack",modifiable:null,stack:null,dispose:function(t){var n=this;if(t&&n.stack)for(;n.stack.length;)n.stack.pop().dispose();return n.modifiable&&n.modifiable.dispose(),n.stack=null,n.modifiable=null,n},getModifiable:function(){return this.modifiable},setModifiable:function(t,n){return this.modifiable=t,n&&this.modifiable.setMesh(n),this},add:function(t){return t&&this.stack.push(t),this},apply:function(){var t=this.modifiable,n=this.stack;return t&&n&&n.length&&t.preApply().resetGeometry().applyModifiers(n).postApply().update(),this},collapse:function(){var t=this.modifiable,n=this.stack;return t&&n&&n.length&&(t.preApply().resetGeometry().applyModifiers(n).collapseGeometry().postApply().update(),n.length=0),this},clear:function(){return this.stack&&(this.stack.length=0),this}}),y.ModifierStack.prototype.getMeshInfo=y.ModifierStack.prototype.getModifiable,y.ModifierStack.prototype.addModifier=y.ModifierStack.prototype.add,(c=y).Pivot=c.Class(c.Modifier,{constructor:function t(n,e,r){if(!(this instanceof t))return new t(n,e,r);this.$super("constructor"),this.name="Pivot",this.vector=new c.Vector3(n||0,e||0,r||0)},vector:null,dispose:function(){return this.vector.dispose(),this.vector=null,this.$super("dispose"),this},setMeshCenter:function(t){return this.vector=new c.Vector3(-(t.minX+.5*t.width),-(t.minY+.5*t.height),-(t.minZ+.5*t.depth)),this},apply:function(t){var n=this.vector,e=n.xyz;return c.List.each(t.vertices,function(t){t.setXYZ(c.Vector3.add(t.getXYZ(),e))}),t.updateMeshPosition(n.negate()),this}}),v=y,g=Math,w=g.PI,V=2*w,X=w/2,v.Bend=v.Class(v.Modifier,{constructor:function t(n,e,r){var i=this;if(!(i instanceof t))return new t(n,e,r);i.$super("constructor"),i.name="Bend",i.constraint=v.ModConstant.NONE,i.switchAxes=!1,i.force=n||0,i.offset=e||0,i.angle=r||0},force:0,offset:0,angle:0,switchAxes:!1,dispose:function(){var t=this;return t.force=null,t.offset=null,t.angle=null,t.switchAxes=null,t.$super("dispose"),t},apply:function(t){var n=this;if(0===n.force)return n;var a=n.constraint,e=n.switchAxes,r=n.force,u=g.min(1,g.max(0,n.offset)),i=n.angle,l=e?t.midAxis:t.maxAxis,c=t.minAxis,f=e?t.maxAxis:t.midAxis,h=t.getSize(l),d=(t.getSize(f),t.getMin(l)),p=(new v.Matrix).rotate(i),m=(new v.Matrix).rotate(-i),x=d+h*u,y=h/w/r,M=h/(y*V)*V;return v.List.each(t.vertices,function(t){var n,e=t.getXYZ(),r=e[v.XYZi[l]],i=e[v.XYZi[f]],o=e[v.XYZi[c]],s=v.Matrix.transform(p,[r,i]),r=s[0],i=s[1],s=(r-d)/h;v.ModConstant.LEFT===a&&s<=u||v.ModConstant.RIGHT===a&&u<=s||(n=X-M*u+M*s,s=g.sin(n)*(y+o),n=g.cos(n)*(y+o),o=s-y,r=x-n),r=(n=v.Matrix.transform(m,[r,i]))[0],i=n[1],e[v.XYZi[l]]=r,e[v.XYZi[f]]=i,e[v.XYZi[c]]=o,t.setXYZ(e)}),n}}),f=y,h=Math,f.Bloat=f.Class(f.Modifier,{constructor:function t(n,e,r){var i=this;if(!(i instanceof t))return new t(n,e,r);i.$super("constructor"),i.name="Bloat",i.radius=n||0,i.a=null==e?.01:e,i.center=r||f.Vector3.ZERO()},radius:0,a:.01,center:null,dispose:function(){var t=this;return t.center.dispose(),t.center=null,t.radius=null,t.a=null,t.$super("dispose"),t},apply:function(t){var r=this.center.xyz,i=h.max(0,this.radius),o=h.max(0,this.a);return f.List.each(t.vertices,function(t){var n=f.Vector3.sub(t.getXYZ(),r),e=f.Vector3.mod(n);f.Vector3.muls(f.Vector3.norm(n),e+i*h.exp(-e*o)),t.setXYZ(f.Vector3.add(n,r))}),this}}),(p=y).Twist=p.Class(p.Modifier,{constructor:function t(n,e,r){var i=this;if(!(i instanceof t))return new t(n,e,r);i.$super("constructor"),i.name="Twist",i.angle=n||0,i.vector=e||p.Vector3.Y(),i.center=r||p.Vector3.ZERO()},angle:0,vector:null,center:null,dispose:function(){var t=this;return t.vector.dispose(),t.vector=null,t.angle=null,t.center.dispose(),t.center=null,t.$super("dispose"),t},apply:function(t){var r=this.vector.normalizeSelf().xyz,i=this.angle,n=this.center.xyz,o=p.Vector3.mod([.5*t.maxX,.5*t.maxY,.5*t.maxZ]),s=-p.Vector3.dot(r,n),a=new p.Matrix4,u=new p.Matrix4;return p.List.each(t.vertices,function(t){var n=t.getXYZ(),e=(p.Vector3.dot(n,r)+s)*i/o,n=p.Matrix4.mult(u.rotate(r[0],r[1],r[2],e,!0),a.translate(n[0],n[1],n[2],!0));t.setXYZ([n.m[3],n.m[7],n.m[11]])}),this}}),m=y,x=Math,m.Skew=m.Class(m.Modifier,{constructor:function t(n,e,r,i){var o=this;if(!(o instanceof t))return new t(n,e,r,i);o.$super("constructor"),o.name="Skew",o.constraint=m.ModConstant.NONE,o.force=null!=n?n:0,o.offset=null!=e?e:.5,o.power=null!=r?r:1,o.falloff=null!=i?i:1,o.inverseFalloff=!1,o.oneSide=!1,o.swapAxes=!1,o.skewAxis=0},force:0,skewAxis:0,offset:.5,power:1,falloff:1,inverseFalloff:!1,oneSide:!1,swapAxes:!1,dispose:function(){var t=this;return t.force=null,t.skewAxis=null,t.offset=null,t.power=null,t.falloff=null,t.inverseFalloff=null,t.oneSide=null,t.swapAxes=null,t.$super("dispose"),t},apply:function(t){var n=this,r=n.constraint,i=n.skewAxis||t.maxAxis,e=n.swapAxes,o=x.min(1,x.max(0,n.offset)),s=n.oneSide,a=!!n.inverseFalloff,u=x.min(1,x.max(0,n.falloff)),l=1-u,c=n.power,f=n.force,h=m.ModConstant.X===i?e?m.ModConstant.Z:m.ModConstant.Y:m.ModConstant.Y===i?e?m.ModConstant.Z:m.ModConstant.X:m.ModConstant.Z===i?e?m.ModConstant.Y:m.ModConstant.X:0;return m.List.each(t.vertices,function(t){var n,e=t.getRatio(i);m.ModConstant.LEFT===r&&e<=o||m.ModConstant.RIGHT===r&&o<e||(n=e-o,s&&n<0&&(n=-n),e=t.getRatio(h),a&&(e=1-e),e=u+e*l,n=(n<0?-1:1)*x.pow(x.abs(n),c),t.setValue(h,t.getValue(h)+f*n*e))}),n}}),M=y,Y=Math,M.Taper=M.Class(M.Modifier,{constructor:function t(n,e,r,i){var o=this;if(!(o instanceof t))return new t(n,e,r,i);o.$super("constructor"),o.name="Taper",o.force=null!=n?n:0,o.power=null!=e?e:1,o.vector=r||M.Vector3.Y(!1),o.vector2=i||M.Vector3.Y()},force:0,power:1,vector:null,vector2:null,dispose:function(){var t=this;return t.vector.dispose(),t.vector2.dispose(),t.vector=null,t.vector2=null,t.force=null,t.power=null,t.$super("dispose"),t},apply:function(t){var n=this,e=n.vector.xyz,r=n.vector2.xyz,i=n.force,o=n.power,s=new M.Matrix4;return M.List.each(t.vertices,1!==o?function(t){var n=M.Vector3.mod(M.Vector3.mul(t.getRatioVector(),r)),n=i*Y.pow(n,o);t.setXYZ(M.Matrix4.multXYZ(s.scale(1+n*e[0],1+n*e[1],1+n*e[2]),t.getXYZ()))}:function(t){var n=M.Vector3.mod(M.Vector3.mul(t.getRatioVector(),r)),n=i*n;t.setXYZ(M.Matrix4.multXYZ(s.scale(1+n*e[0],1+n*e[1],1+n*e[2]),t.getXYZ()))}),n}}),(A=y).Wheel=A.Class(A.Modifier,{constructor:function t(n,e,r,i,o){var s=this;if(!(s instanceof t))return new t(n,e,r,i,o);s.$super("constructor"),s.name="Wheel",s.speed=n||0,s.turn=e||0,s.roll=r||0,s.steerVector=i||A.Vector3.Y(),s.rollVector=o||A.Vector3.Z()},speed:0,turn:0,roll:0,steerVector:null,rollVector:null,dispose:function(){var t=this;return t.speed=null,t.turn=null,t.roll=null,t.steerVector.dispose(),t.rollVector.dispose(),t.steerVector=null,t.rollVector=null,t.$super("dispose"),t},apply:function(t){var n=this,e=n.steerVector.normalizeSelf(),r=n.rollVector.normalizeSelf(),i=n.turn,o=n.roll,s=null,a=null;return n.roll+=n.speed,s=i?(a=(new A.Matrix4).rotateFromVector(e,i),(new A.Matrix4).rotateFromVector(a.multiplyVector(r.clone()),o)):(new A.Matrix4).rotateFromVector(r,o),A.List.each(t.vertices,a?function(t){t.setXYZ(A.Matrix4.multXYZ(s,A.Matrix4.multXYZ(a,t.getXYZ())))}:function(t){t.setXYZ(A.Matrix4.multXYZ(s,t.getXYZ()))}),n}}),Z=y,C=Math,Z.Break=Z.Class(Z.Modifier,{constructor:function t(n,e,r){var i=this;if(!(i instanceof t))return new t(n,e,r);i.$super("constructor"),i.name="Break",i.offset=n||0,i.angle=e||0,i.vector=r||Z.Vector3.Y(),i.range=new Z.Range(0,1)},offset:0,angle:0,vector:null,range:null,dispose:function(){var t=this;return t.vector.dispose(),t.range.dispose(),t.vector=null,t.range=null,t.offset=null,t.angle=null,t.$super("dispose"),t},apply:function(t){var n=this,e=C.min(1,C.max(0,n.offset)),r=n.range,i=n.angle,o=n.vector.normalizeSelf().xyz,s=t.minZ+t.depth*e,a=(new Z.Matrix4).rotate(o[0],o[1],o[2],i);return Z.List.each(t.vertices,function(t){var n=t.getXYZ();n[2]-=s,0<=n[2]&&r.isIn(t.ratio[1])&&Z.Matrix4.multXYZ(a,n),n[2]+=s,t.setXYZ(n)}),n}}),z=y,S=Math,z.Noise=z.Class(z.Modifier,{constructor:function t(n){var e=this;if(!(e instanceof t))return new t(n);e.$super("constructor"),e.name="Noise",e.force=n||0,e.start=0,e.end=1,e.axes=z.ModConstant.X|z.ModConstant.Y|z.ModConstant.Z},force:0,start:0,end:1,dispose:function(){var t=this;return t.force=null,t.start=null,t.end=null,t.$super("dispose"),t},setFalloff:function(t,n){return this.start=null!=t?t:0,this.end=null!=n?n:1,this},apply:function(t){var n=this,r=n.axes,i=n.start,o=n.end,s=n.force,a=.5*s,u=t.maxAxis;return 0==r||0==s||z.List.each(t.vertices,function(t){var n=S.random()*s-a,e=t.getRatio(u);i<o?e<i?e=0:o<e&&(e=1):o<i?i<(e=1-e)?e=0:e<o&&(e=1):e=1,n=n*e,e=t.getXYZ(),t.setXYZ([e[0]+(r&z.ModConstant.X?n:0),e[1]+(r&z.ModConstant.Y?n:0),e[2]+(r&z.ModConstant.Z?n:0)])}),n}}),(P=y).DisplaceMap=P.Class(P.Modifier,{constructor:function t(n,e,r){var i=this;if(!(i instanceof t))return new t(n,e,r);i.$super("constructor"),i.name="DisplaceMap",+n===n?(i.force=n||1,i.offset=null==e?127:e):(i.setBitmap(n),i.force=e||1,i.offset=null==r?127:r),i.axes=P.ModConstant.X|P.ModConstant.Y|P.ModConstant.Z},width:null,height:null,bmpData:null,force:1,offset:127,dispose:function(){var t=this;return t.bmpData=null,t.width=null,t.height=null,t.force=null,t.offset=null,t.$super("dispose"),t},setBitmap:function(t){return this.bmpData=t?t.data:null,this.width=t?t.width:0,this.height=t?t.height:0,this},apply:function(t){var n=this,r=n.axes,i=n.width,o=n.height,s=n.bmpData,a=n.force,u=n.offset;return r&&s&&P.List.each(t.vertices,function(t){var n=t.getXYZ(),e=~~((i-1)*t.ratio[0]),e=~~((o-1)*t.ratio[2])*i+e<<2;t.setXYZ([n[0]+(r&P.ModConstant.X?((255&s[e])-u)*a:0),n[1]+(r&P.ModConstant.Y?((255&s[1+e])-u)*a:0),n[2]+(r&P.ModConstant.Z?((255&s[2+e])-u)*a:0)])}),n}}),(F=y).Perlin=F.Class(F.Modifier,{constructor:function t(n,e,r){var i=this;if(!(i instanceof t))return new t(n,e,r);i.$super("constructor"),i.name="Perlin",i.force=null!=n?n:1,i.perlin=e,i.autoRun=null==r||!!r,i.axes=F.ModConstant.X|F.ModConstant.Y|F.ModConstant.Z},speedX:1,speedY:1,perlin:null,force:1,offset:0,autoRun:!0,dispose:function(){var t=this;return t.perlin=null,t.speedX=null,t.speedY=null,t.force=null,t.offset=null,t.autoRun=null,t.$super("dispose"),t},setSpeed:function(t,n){return this.speedX=t,this.speedY=n,this},apply:function(t){var r,i,n=this,o=n.axes,s=n.force,a=n.offset,u=n.perlin;return o&&u&&(r=u.width,i=u.height,n.autoRun&&((u=n.perlin=function(t,n,e,r,i){var o,s,a,u,l,c=n*e,f=new F.VecArray(c);for(r<0&&(r+=n),i<0&&(i+=e),r=~~r,i=~~i,l=s=o=0;l<c;++l,++o)n<=o&&(o=0,++s),a=(o+r)%n,u=(s+i)%e,f[l]=t[a+u*n];return f}(u,r,i,n.speedX,n.speedY)).width=r,u.height=i),F.List.each(t.vertices,function(t){var n=t.getXYZ(),e=~~((r-1)*t.ratio[0])+~~((i-1)*t.ratio[2])*r;t.setXYZ([n[0]+(o&F.ModConstant.X?(u[e]-a)*s:0),n[1]+(o&F.ModConstant.Y?(u[e]-a)*s:0),n[2]+(o&F.ModConstant.Z?(u[e]-a)*s:0)])})),n}}),y});