<?php
	// FOR DEV ONLY
	//error_reporting(E_ALL);
	//ini_set('display_errors', '1');
  
  // custom login logo
  function my_custom_login_logo() {
  	echo '<style type="text/css">
      	h1 a { background-image:url('.get_bloginfo('template_directory').'/library/images/lionhouse-logo.svg) !important; background-size: 70% auto !important; width: auto !important; height: 100px !important }
      	</style>';
  }
  add_action('login_head', 'my_custom_login_logo');
  
  // custom favicons
	function add_favicon() {
		echo '<meta itemprop="name" content="' . get_bloginfo('name' ) . '">
		<meta itemprop="description" content="' . get_bloginfo('description' ) . '">
		<meta itemprop="image" content="' . get_stylesheet_directory_uri() . '/library/images/icons/lionhouse.png">
		<link rel="shortcut icon" type="image/x-icon" href="' . get_stylesheet_directory_uri() . '/library/images/icons/favicon.ico">
		<link rel="icon" type="image/png" href="' . get_stylesheet_directory_uri() . '/library/images/icons/favicon-32x32.png" sizes="32x32" />
		<link rel="icon" type="image/png" href="' . get_stylesheet_directory_uri() . '/library/images/icons/favicon-16x16.png" sizes="16x16" />
		<link rel="apple-touch-icon" href="' . get_stylesheet_directory_uri() . '/library/images/icons/apple-touch-icon.png">';
	}
	add_action('login_head', 'add_favicon');
	add_action('admin_head', 'add_favicon');
	add_action('wp_head', 'add_favicon');
	
	// Remove Tags from Post Column
	function my_columns_filter( $columns ) {
    unset($columns['tags']);
    unset($columns['author']);
    unset($columns['comments']);
    return $columns;
	}
	add_filter( 'manage_edit-post_columns', 'my_columns_filter', 10, 1 );
	add_filter( 'manage_edit-page_columns', 'my_columns_filter', 10, 1 );
  
  // disable admin bar
  add_filter('show_admin_bar', '__return_false');  
	
	// Enqueue scripts properly
	function theme_scripts() {
		wp_deregister_script('jquery');
		wp_dequeue_style('wp-block-library');
		wp_enqueue_style('css', get_bloginfo('stylesheet_url'), false, filemtime(get_template_directory().'/style.css'));
		wp_enqueue_script(
			'plugins',
			get_stylesheet_directory_uri() . '/library/js/plugins.js',
			null, filemtime(get_template_directory(). '/library/js/plugins.js'), false
		);
		wp_enqueue_script(
			'script',
			get_stylesheet_directory_uri() . '/library/js/scripts.js',
			array('plugins'), filemtime(get_template_directory() . '/library/js/scripts.js'), false
		);
		wp_localize_script( 'script', 'script_vars', array( 'ajax_url' => admin_url('admin-ajax.php') ) );
	}
	add_action('wp_enqueue_scripts', 'theme_scripts');
	
	// Add defer
	function gioga_add_defer_attribute($tag, $handle) {
		if ( 'script' !== $handle AND 'plugins' !== $handle )
			return $tag;
			return str_replace( ' src', ' defer src', $tag );
	}
	add_filter('script_loader_tag', 'gioga_add_defer_attribute', 10, 2);
	
	// Clean up the <head>
	function complete_version_removal() {
		return '';
	}
	add_filter('the_generator', 'complete_version_removal');
	
	remove_action( 'wp_head', 'feed_links_extra', 3 ); // Display the links to the extra feeds such as category feeds
	remove_action( 'wp_head', 'feed_links', 2 ); // Display the links to the general feeds: Post and Comment Feed
	remove_action( 'wp_head', 'rsd_link' ); // Display the link to the Really Simple Discovery service endpoint, EditURI link
	remove_action( 'wp_head', 'wlwmanifest_link' ); // Display the link to the Windows Live Writer manifest file.
	remove_action( 'wp_head', 'index_rel_link' ); // index link
	remove_action( 'wp_head', 'parent_post_rel_link', 10, 0 ); // prev link
	remove_action('wp_head', 'start_post_rel_link', 10, 0 ); // start link
	remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0); // previous and next links
	remove_action('wp_head', 'rel_canonical');
	remove_action( 'wp_head', 'wp_shortlink_wp_head', 10, 0 );
	
	// all actions related to emojis
  remove_action( 'admin_print_styles', 'print_emoji_styles' );
  remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
  remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
  remove_action( 'wp_print_styles', 'print_emoji_styles' );
  remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
  remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
  remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );

  // filter to remove TinyMCE emojis
  add_filter( 'tiny_mce_plugins', 'disable_emojicons_tinymce' );  
  function disable_emojicons_tinymce( $plugins ) {
	  if ( is_array( $plugins ) ) {
	    return array_diff( $plugins, array( 'wpemoji' ) );
	  } else {
	    return array();
	  }
	}
    
  // Thumbnail Support
  add_theme_support( 'post-thumbnails' );
  //add_image_size( 'video-thumb', 9999, 405 );
  
  // Better Navigation
  register_nav_menu( 'header', __( 'Header menu' ) );
  register_nav_menu( 'footer1', __( 'Footer menu 1' ) );
  register_nav_menu( 'footer2', __( 'Footer menu 2' ) );
  register_nav_menu( 'footer3', __( 'Footer menu 3' ) );
  register_nav_menu( 'footer4', __( 'Footer menu 4' ) );
  register_nav_menu( 'footer5', __( 'Footer menu 5' ) );
  register_nav_menu( 'footersubmenu', __( 'Footer sub menu' ) );
  
  //Deletes all CSS classes and id's, except for those listed in the array below
	function custom_wp_nav_menu($var) {
	  return is_array($var) ? array_intersect($var, array(
	    //List of allowed menu classes
	    'current-menu-item',
	    'current_page_parent',
	    'current_page_ancestor',
	    'first',
	    'last',
	    'vertical',
	    'horizontal'
	    )
	  ) : '';
	}
	add_filter('nav_menu_css_class', 'custom_wp_nav_menu');
	add_filter('nav_menu_item_id', 'custom_wp_nav_menu');
	add_filter('page_css_class', 'custom_wp_nav_menu');
	 
	//Deletes empty classes and removes the sub menu class
	function strip_empty_classes($menu) {
    $menu = preg_replace('/ class=""| class="sub-menu"/',' class="header-nav__sub-listing"',$menu);
    return $menu;
	}
	add_filter ('wp_nav_menu','strip_empty_classes');
	
	function add_has_children_to_nav_items( $items ) {
    $parents = wp_list_pluck( $items, 'menu_item_parent');

    foreach ( $items as $item )
      in_array( $item->ID, $parents ) && $item->classes[] = 'has-children';

    return $items;
	}
	add_filter( 'wp_nav_menu_objects', 'add_has_children_to_nav_items' );
	
	class Header_Nav_Walker extends Walker_Nav_Menu {
	    
	  function start_el(&$output, $item, $depth=0, $args=array(), $id = 0) {
    	$object = $item->object;
    	$type = $item->type;
    	$title = $item->title;
    	$permalink = $item->url;
    	$classes = $item->classes;
    	    	    	
    	if (@in_array('has-children', $classes)) :
		    $output .= "<li class='header-nav__item header-nav__item--has-subs'>";
	    elseif ($item->menu_item_parent) :
		    $output .= "<li class='header-nav__sub-item'>";
	    else :
		    $output .= "<li class='header-nav__item'>";
    	endif;
    	        
      //Add SPAN if no Permalink
      if( $permalink && $permalink != '#' && $permalink != '' ) {
	      
	      if (@in_array('has-children', $classes) AND !$item->menu_item_parent) :
		      $output .= '<a href="' . $permalink . '" class="header-nav__item-link link-underline type-h1 type-bold">';
      	elseif (!$item->menu_item_parent) :
	      	$output .= '<a href="' . $permalink . '" class="header-nav__item-link link-underline type-h1 type-bold">';
	      else :
		      $output .= '<a href="' . $permalink . '" class="header-nav__sub-item-link link-underline type-h4">';
      	endif;
      	
      } else {
	      if (@in_array('has-children', $classes)) {
		      $output .= '<span class="header-nav__item-link link-underline type-h1 type-bold">';
	      } else {
	      	$output .= '<span>';
      	}
      }
       
      $output .= $title;
      
      if( $permalink && $permalink != '#' && $permalink != '' ) {

      	$output .= '</a>';
      	
      	if (@in_array('has-children', $classes)) {
	      	
	      	$output .= '<button type="button" class="header-nav__item-expand-btn"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 21.97 15.4" class="header-nav__item-expand-icon"><path d="M20.27 2.71L11 12 1.71 2.71" fill="none" stroke-width="2"/></svg></button>';
	      	
      	}
      	
      } else {

      	$output .= '</span>';

      }
    }
	  
	}
	
	class Footer_Nav_Walker extends Walker_Nav_Menu {
	    
	  function start_el(&$output, $item, $depth=0, $args=array(), $id = 0) {
		  		  
		  $object = $item->object;
    	$type = $item->type;
    	$title = $item->title;
    	$permalink = $item->url;
    	$order = $item->menu_order;

	    $output .= "<li class='footer-links__item'>";
	    
	    if ($order == 1) :
		    $output .= "<strong>";
	    endif;
	    
	    //Add SPAN if no Permalink
      if( $permalink && $permalink != '#' && $permalink != '' ) {
      	$output .= '<a href="' . $permalink . '" class="link-underline">';
      } else {
      	$output .= '<span>';
      }
       
      $output .= $title;
      
      if ($order == 1) :
		    $output .= "</strong>";
	    endif;

      if( $permalink && $permalink != '#' && $permalink != '' ) {
      	$output .= '</a>';
      } else {
      	$output .= '</span>';
      }
   
    }
	  
	}
	
	class Footer_SubNav_Walker extends Walker_Nav_Menu {
	    
	  function start_el(&$output, $item, $depth=0, $args=array(), $id = 0) {
		  
		  $object = $item->object;
    	$type = $item->type;
    	$title = $item->title;
    	$permalink = $item->url;
    	$order = $item->menu_order;

	    $output .= "<li class='footer-inline-links__item'>";
	    
	    //Add SPAN if no Permalink
      if( $permalink && $permalink != '#' && $permalink != '' ) {
      	$output .= '<a href="' . $permalink . '">';
      } else {
      	$output .= '<span>';
      }
       
      $output .= $title;

      if( $permalink && $permalink != '#' && $permalink != '' ) {
      	$output .= '</a>';
      } else {
      	$output .= '</span>';
      }
   
    }
	  
	}
  
  function header_nav() {
	  wp_nav_menu( $menuParameters = array( 'theme_location' => 'header', 'items_wrap' => '%3$s', 'fallback_cb' => 'wp_page_menu', 'depth' => 0, 'echo' => true, 'container_id' => 'Menu', 'container' => '', 'walker' => new Header_Nav_Walker() ) ); 
  }
  
  function footer_nav($location) {
	  wp_nav_menu( $menuParameters = array( 'theme_location' => $location, 'items_wrap' => '<ul class="footer-links">%3$s</ul>', 'fallback_cb' => 'wp_page_menu', 'depth' => 0, 'echo' => true, 'container_id' => 'Menu', 'container' => '', 'walker' => new Footer_Nav_Walker() ) ); 
  }
  
  function footer_subnav($location) {
	  wp_nav_menu( $menuParameters = array( 'theme_location' => $location, 'items_wrap' => '<ul class="footer-inline-links type-sm">%3$s</ul>', 'fallback_cb' => 'wp_page_menu', 'depth' => 0, 'echo' => true, 'container_id' => 'Menu', 'container' => '', 'walker' => new Footer_SubNav_Walker() ) ); 
  }
  
  function my_body_class($wp_classes, $extra_classes) {
	  // List of the only WP generated classes allowed
	  $whitelist = array('page', 'home', 'error404', 'blog', 'single');
	
	  // Filter the body classes
	  $wp_classes = array_intersect($wp_classes, $whitelist);
	
	  // Add the extra classes back untouched
	  return array_merge($wp_classes, (array) $extra_classes);
	}
	add_filter('body_class', 'my_body_class', 10, 2);
	
	add_filter('body_class', 'remove_a_body_class', 20, 2);
	function remove_a_body_class($wp_classes) {
		if( is_page_template('home-template.php') ) :
		foreach($wp_classes as $key => $value) {
			if ($value == 'page') unset($wp_classes[$key]);
		}
		endif;
		return $wp_classes;
	}
	
	// Rename posts to articles
	function revcon_change_post_label() {
    global $menu;
    global $submenu;
    $menu[5][0] = 'Articles';
    $submenu['edit.php'][5][0] = 'Articles';
    $submenu['edit.php'][10][0] = 'Add Article';
    $submenu['edit.php'][16][0] = 'Article Tags';
    echo '';
	}
	function revcon_change_post_object() {
    global $wp_post_types;
    $labels = &$wp_post_types['post']->labels;
    $labels->name = 'Articles';
    $labels->singular_name = 'Article';
    $labels->add_new = 'Add Article';
    $labels->add_new_item = 'Add Article';
    $labels->edit_item = 'Edit Article';
    $labels->new_item = 'Article';
    $labels->view_item = 'View Article';
    $labels->search_items = 'Search Article';
    $labels->not_found = 'No Articles found';
    $labels->not_found_in_trash = 'No Articles found in Trash';
    $labels->all_items = 'All Articles';
    $labels->menu_name = 'Articles';
    $labels->name_admin_bar = 'Articles';
	}
	add_action( 'admin_menu', 'revcon_change_post_label' );
	add_action( 'init', 'revcon_change_post_object' );
	
	// Disabling the JSON REST API
  // Disable REST API link tag
	remove_action('wp_head', 'rest_output_link_wp_head', 10);
	// Disable oEmbed Discovery Links
	remove_action('wp_head', 'wp_oembed_add_discovery_links', 10);
	// Disable REST API link in HTTP headers
	remove_action('template_redirect', 'rest_output_link_header', 11, 0);
	
	add_action('admin_menu', 'my_remove_sub_menus');
	function my_remove_sub_menus() {
    remove_submenu_page('edit.php', 'edit-tags.php?taxonomy=post_tag');
	}
	
	function send_contact_form() {

		$email_address = get_field('global_form_email', 'options');
		
		$email_message_head = '<html><meta name="viewport" content="width=device-width" /><body><table style="width:100%;" cellpadding="0" cellspacing="0" border="0" bgcolor="FFFFFF"><tr><td><table width="100%" style="width:100%;max-width:600px;" cellpadding="0" cellspacing="0" border="0"><tr><td>';
		
		$email_message_foot = '</td></tr><tr><td height="20" style="font-size: 20px; line-height: 20px;">&nbsp;</td></tr></table></td></tr></table></body></html>';
		
		$email_headers = array(
		  'From: ' . get_bloginfo('name') . ' <no-reply@mail.lionhouse.com.au>',
		  'Reply-To: ' . get_bloginfo('name') . ' <no-reply@mail.lionhouse.com.au>',
		  'MIME-Version: 1.0',
		  'Content-type: text/html; charset=iso-8859-1'
		);
		$email_headers = implode( "\r\n" , $email_headers );
					
		if(isset($_POST['hduuss']) AND $_POST['hduuss'] == '') {
						
			$fname = trim($_POST['fname']);
			$lname = trim($_POST['lname']);
			$email = trim($_POST['email']);
			$phone = trim($_POST['phone']);
			$message = trim($_POST['message']);
		
			$email_message = $email_message_head;
			
			$email_message .= '<p style="font-family:Arial,sans-serif;font-weight:normal;font-size:12px;line-height:1.2;"><strong>First name</strong><br>'.$fname.'<br><br><strong>Last name</strong><br>'.$lname.'<br><br><strong>Email</strong><br>'.$email.'<br><br><strong>Phone</strong><br>'.$phone.'<br><br><strong>Message</strong><br>'.$message;
			
			$email_message .= '</p>';
	
			$email_message .= $email_message_foot;
			
			$email_subject = get_bloginfo('name') . ' website enquiry from ' . $fname . ' ' . $lname;
			
			wp_mail($email_address, $email_subject, $email_message, $email_headers);
			
			//echo $email_address . $email_subject . $email_message . $email_headers;
					  
			exit();
				
		}
	}
	add_action( 'wp_ajax_send_contact_form', 'send_contact_form' );
  add_action( 'wp_ajax_nopriv_send_contact_form', 'send_contact_form' );
  
  function my_theme_add_editor_styles() {
	  add_editor_style( 'custom-editor-style.css' );
	}
	add_action( 'init', 'my_theme_add_editor_styles' );
		
	$global_logo = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 110.07 43.24" aria-label="LionHouse Logo" class="header__logo-svg"><g class="header__logo-icon"><path d="M6.04 16.62H4.7v6.08h4.37v-1.21H6.04v-4.87z"/><path d="M20.46 7.87h-7V6.72l3-3L12.8 0 9.1 3.71l3 3v1.16h-7v1.36h15.36zM11 3.71l1.8-1.79 1.78 1.79-1.78 1.78zM0 12.24V37l12.81 6.25L25.6 37V12.24zm23.15 1.35l-9.66 11v-11zm-11 18.31l-9.66-4.81h9.64zm0 1.52V37L1.36 31.61V28zM1.36 13.59h10.77v12.14H1.36zm0 22.55v-3l10.77 5.37v2.89zm22.88 0L13.49 41.4V27.09h10.75zm-10-10.42l10-11.32v11.33z"/><path d="M17.64 33.06h2.47v2.44h1.34v-6.08h-1.34v2.4h-2.47v-2.4H16.3v6.08h1.34v-2.44z"/></g><g class="header__logo-type"><path d="M38.5 27v-5.63H37v7h5V27zM44.68 21.37v7h1.55v-7zM52.87 21.25a3.63 3.63 0 00-3.75 3.63 3.74 3.74 0 007.47 0 3.6 3.6 0 00-3.72-3.63zM55 24.9a2.09 2.09 0 01-2.1 2.18 2.13 2.13 0 01-2.13-2.2 2.1 2.1 0 012.11-2.19A2.13 2.13 0 0155 24.88zM64.12 21.37v4.32l-3.29-4.32h-1.42v7h1.52v-4.45l3.4 4.47h1.32v-7zM73.18 21.37v2.78h-2.85v-2.78h-1.55v7h1.55v-2.8h2.85v2.82h1.54v-7zM81.28 21.25a3.63 3.63 0 00-3.74 3.63 3.73 3.73 0 007.46 0 3.59 3.59 0 00-3.72-3.63zm2.11 3.65a2.1 2.1 0 01-2.11 2.18 2.13 2.13 0 01-2.12-2.2 2.1 2.1 0 012.1-2.19 2.14 2.14 0 012.13 2.21zM92.29 21.37v4c0 1.11-.57 1.68-1.52 1.68s-1.51-.59-1.51-1.73v-4h-1.54v4a2.78 2.78 0 003 3.11 2.82 2.82 0 003.08-3.16v-4zM99.71 24.19c-1.22-.32-1.51-.47-1.51-.93 0-.34.3-.61.89-.61a3.29 3.29 0 011.83.69l.8-1.16a4.06 4.06 0 00-2.61-.89 2.19 2.19 0 00-2.45 2.11c0 1.4.91 1.79 2.33 2.15 1.17.3 1.41.5 1.41.89 0 .41-.38.66-1 .66a3.22 3.22 0 01-2.1-.85l-.91 1.09a4.49 4.49 0 003 1.13c1.51 0 2.57-.78 2.57-2.18-.03-1.22-.83-1.73-2.25-2.1zM106.26 27v-1.46h3.31v-1.37h-3.31v-1.43H110v-1.37h-5.29v7h5.34V27z"/></g></svg>';

	$global_styles = null;
	
	if ($global_branding = get_field('global_branding', 'options')) :
	
		if ($global_branding == 'Accounting') :
		
			$global_logo = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 442.96 111.07" aria-label="LionHouse Accounting logo" class="header__logo-svg"><g class="header__logo-type"><path d="M98.43 43.39v-12h-3.29v15h10.79v-3zM111.69 31.39v15H115v-15zM129.18 31.13a7.76 7.76 0 00-8 7.76 7.67 7.67 0 008 7.71 7.76 7.76 0 008-7.76 7.67 7.67 0 00-8-7.71zm4.52 7.81a4.5 4.5 0 01-4.52 4.68 4.58 4.58 0 01-4.55-4.73 4.5 4.5 0 014.52-4.68 4.58 4.58 0 014.55 4.73zM153.27 31.39v9.25l-7-9.25h-3v15h3.27v-9.53l7.27 9.53h2.8v-15zM172.67 31.39v5.93h-6.09v-5.93h-3.31v15h3.31v-6h6.09v6H176v-15zM190 31.13a7.76 7.76 0 00-8 7.76 7.69 7.69 0 008 7.71 7.78 7.78 0 008-7.76 7.69 7.69 0 00-8-7.71zm4.5 7.81a4.5 4.5 0 01-4.5 4.68 4.56 4.56 0 01-4.54-4.73 4.48 4.48 0 014.54-4.73 4.57 4.57 0 014.55 4.73zM213.59 31.39V40c0 2.37-1.24 3.6-3.24 3.6s-3.24-1.26-3.24-3.72v-8.49h-3.31V40c0 4.42 2.47 6.68 6.5 6.68s6.6-2.24 6.6-6.78v-8.51zM229.46 37.4c-2.59-.67-3.24-1-3.24-1.95v-.05c0-.75.67-1.31 1.93-1.31a7.07 7.07 0 013.91 1.49l1.72-2.5a8.66 8.66 0 00-5.58-1.92c-3.08 0-5.26 1.8-5.26 4.54 0 3 1.95 3.83 5 4.6 2.52.64 3 1.08 3 1.9v.05c0 .87-.82 1.41-2.18 1.41a6.77 6.77 0 01-4.47-1.82l-2 2.34a9.45 9.45 0 006.37 2.41c3.23 0 5.52-1.67 5.52-4.67.06-2.62-1.66-3.72-4.72-4.52zM243.49 43.46V40.3h7.09v-2.93h-7.09v-3h8.06v-2.98h-11.33v15h11.43v-2.93zM90.37 92.61l13.53-31.56h4.28l13.52 31.56h-6.35l-3-7H99.71l-3 7zM102 80.21h8l-4-9.33zM133.43 76.83a10.62 10.62 0 0010.77 10.82 11 11 0 008.93-4.37l4.19 3.72a16.58 16.58 0 01-13.25 6c-9.83 0-16.72-7.17-16.72-16.23S134.15 60.6 144 60.6a16.4 16.4 0 0111.54 4.51l-3.92 4.15a10.81 10.81 0 00-7.68-3.26 10.54 10.54 0 00-10.51 10.83zM170.86 76.83a10.61 10.61 0 0010.77 10.82 11 11 0 008.92-4.37l4.19 3.72a16.58 16.58 0 01-13.25 6c-9.82 0-16.72-7.17-16.72-16.23s6.81-16.17 16.63-16.17a16.4 16.4 0 0111.54 4.51L189 69.26a10.78 10.78 0 00-7.64-3.26 10.53 10.53 0 00-10.5 10.83zM218.65 60.6c9.73 0 16.45 7.26 16.45 16.23s-6.72 16.23-16.45 16.23-16.46-7.26-16.46-16.23 6.72-16.23 16.46-16.23zm0 27.05c5.95 0 10.36-4.87 10.36-10.82S224.6 66 218.65 66s-10.37 4.87-10.37 10.82 4.42 10.83 10.37 10.83zM249.54 89.81c-2.62-2.34-4.06-5.68-4.06-10.5V61.05h6.08v18.71c0 2.89.77 4.64 2.08 5.86a8.1 8.1 0 0010.73 0c1.3-1.22 2.07-3 2.07-5.86V61.05h6.09v18.26c0 4.82-1.45 8.16-4.06 10.5a15.41 15.41 0 01-18.93 0zM284.93 61.05h4.29l17.57 20.56V61.05h6.09v31.56h-4.28L291 72.05v20.56h-6.09zM345.8 61.05v5.41h-8.34v26.15h-6.09V66.46H323v-5.41zM356 61.05h6v31.56h-6zM374.66 61.05H379l17.57 20.56V61.05h6.09v31.56h-4.28l-17.63-20.56v20.56h-6.09zM419.07 76.83a10.62 10.62 0 0010.77 10.82 11 11 0 007-2.44v-6.8h-8.12V73H443v14a16.58 16.58 0 01-13.25 6c-9.83 0-16.72-7.17-16.72-16.23s6.8-16.23 16.63-16.23a16.4 16.4 0 0111.54 4.51l-3.92 4.15a10.79 10.79 0 00-7.7-3.2 10.54 10.54 0 00-10.51 10.83z"/></g><g class="header__logo-icon"><path d="M0 31.44V95l32.9 16 32.86-16V31.44zm32.9 75.75L3.49 92.83V52.32L50 98.84zm29.37-14.36l-9 4.4L3.49 47.39V34.91h9l49.78 49.78zm0-13.07L17.42 34.91h44.85zM34.65 20.22v-3l7.73-7.73L32.88 0l-9.5 9.53 7.78 7.78v2.91h-18v3.49h39.4v-3.49zM28.31 9.53l4.57-4.6 4.57 4.6-4.57 4.57z"/></g></svg>';
			
			$global_styles = '
			:root {
				--highlight-color: var(--accounting-color);
			}
			
			/* Header */
			.header__logo-svg {
				width: 18.75rem;
			}
			
			@media screen and (max-width: 47.9375em) {
				
				.header__logo-svg {
					width: 15.75rem;
				}
				
			}
			';
		
		elseif ($global_branding == 'Legal') :
		
			$global_logo = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 251.28 111.07" aria-label="LionHouse Legal logo" class="header__logo-svg"><g class="header__logo-type"><path d="M98.28 43.32v-12H95v15h10.76v-3zM111.51 31.32v15h3.29v-15zM129 31.06a7.76 7.76 0 00-8 7.76 8 8 0 0016 0 7.7 7.7 0 00-8-7.76zm4.52 7.81a4.5 4.5 0 01-4.52 4.68 4.56 4.56 0 01-4.52-4.73 4.48 4.48 0 014.52-4.7 4.56 4.56 0 014.55 4.7zM153.05 31.32v9.25l-7-9.25h-3v15h3.26v-9.53l7.27 9.53h2.81v-15zM172.4 31.32v5.93h-6.09v-5.93H163v15h3.29v-6h6.09v6h3.31v-15zM189.74 31.06a7.76 7.76 0 00-8 7.76 7.68 7.68 0 007.94 7.71 7.75 7.75 0 008-7.76 7.69 7.69 0 00-7.94-7.71zm4.5 7.81a4.5 4.5 0 01-4.5 4.68 4.57 4.57 0 01-4.55-4.73 4.5 4.5 0 014.5-4.68 4.54 4.54 0 014.55 4.7zM213.28 31.32v8.61c0 2.36-1.24 3.59-3.24 3.59s-3.24-1.26-3.24-3.7v-8.5h-3.31v8.58c0 4.42 2.46 6.66 6.5 6.66s6.57-2.21 6.57-6.76v-8.48zM229.13 37.36c-2.6-.67-3.24-1-3.24-2v-.05c0-.72.67-1.31 1.93-1.31a7 7 0 013.9 1.49l1.7-2.49a8.7 8.7 0 00-5.55-1.91c-3.08 0-5.27 1.8-5.27 4.53 0 3 2 3.8 5 4.57 2.49.64 3 1.08 3 1.9v.05c0 .88-.79 1.42-2.15 1.42A6.76 6.76 0 01224 41.8l-2 2.34a9.5 9.5 0 006.37 2.42c3.24 0 5.5-1.67 5.5-4.65v-.06c.01-2.62-1.71-3.7-4.74-4.49zM243.13 43.4v-3.16h7.07v-2.93h-7.07v-3h8v-3h-11.3v15h11.41V43.4zM95 60.53h6.09v26.15h13.3v5.41H95zM130.59 65.94v6.54h9.7v5.41h-9.7v8.79h13.31v5.41h-19.39V60.53h18.93v5.41zM157.88 76.31a10.62 10.62 0 0010.78 10.82 11 11 0 007-2.44v-6.8h-8.11v-5.41h14.2v14a16.61 16.61 0 01-13.26 6c-9.83 0-16.72-7.17-16.72-16.23s6.8-16.23 16.63-16.23a16.42 16.42 0 0111.6 4.56l-3.93 4.15a10.81 10.81 0 00-7.66-3.24 10.53 10.53 0 00-10.53 10.82zM189.23 92.09l13.53-31.56H207l13.52 31.56h-6.35l-3-7h-12.61l-3 7zm11.63-12.4h8l-4-9.33zM229.59 60.53h6.09v26.15H249v5.41h-19.41z"/></g><g class="header__logo-icon"><path d="M0 31.42V95l32.91 16 32.84-16V31.42zm32.91 75.8L3.49 92.85V37.31L61 93.47zm29.37-17.4L6 34.92h56.28zM34.66 20.22v-2.95l7.73-7.74L32.89 0l-9.51 9.53 7.79 7.79v2.9h-18v3.49h39.4v-3.49zM28.31 9.53l4.58-4.6 4.57 4.6-4.57 4.58z"/></g></svg>';
			
			$global_styles = '
			:root {
				--highlight-color: var(--legal-color);
			}
			
			/* Header */
			.header__logo-svg {
				width: 10.5rem;
			}
			
			@media screen and (max-width: 47.9375em) {
				
				.header__logo-svg {
					width: 8rem;
				}
				
			}
			';
			
		elseif ($branding == 'Marketing') :
		
			$logo = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 154.45 43.16" aria-label="LionHouse Marketing logo" class="header__logo-svg"><g fill="#b3a463" class="header__logo-icon"><path d="M0 12.21v24.72l12.79 6.23 12.76-6.23V12.21zm24.19 1.36v12.11H1.35V13.57zm-11.4 28.09L1.35 36.08V27h22.84v9zM20.42 7.86h-7V6.79h-.1l3.1-3.09L12.77 0 9.08 3.7l3.1 3.09h-.07v1.07h-7v1.35h15.31zm-7.65-5.94l1.78 1.78-1.78 1.78L11 3.7z"/></g><g fill="#262948" class="header__logo-type"><path d="M37 18v-5.81h1.28v4.68h2.92V18zM43.4 18v-5.81h1.29V18zM50.19 18.13a3 3 0 01-3.09-3 3.1 3.1 0 016.2 0 3 3 0 01-3.11 3zm1.77-3a1.77 1.77 0 00-1.77-1.83 1.75 1.75 0 00-1.75 1.82A1.78 1.78 0 0050.21 17 1.75 1.75 0 0052 15.13zM59.75 18l-2.83-3.71V18h-1.27v-5.81h1.19l2.73 3.6v-3.6h1.27V18zM67.1 18v-2.31h-2.36V18h-1.29v-5.81h1.29v2.31h2.36v-2.31h1.29V18zM73.83 18.13a3 3 0 01-3.09-3 3.11 3.11 0 016.21 0 3 3 0 01-3.12 3zm1.77-3a1.77 1.77 0 00-1.77-1.83 1.75 1.75 0 00-1.75 1.82A1.78 1.78 0 0073.85 17a1.74 1.74 0 001.75-1.82zM81.73 18.12a2.31 2.31 0 01-2.52-2.59v-3.34h1.28v3.31c0 .95.48 1.44 1.26 1.44s1.25-.48 1.25-1.4v-3.35h1.28v3.3a2.34 2.34 0 01-2.55 2.63zM88.89 18.12a3.69 3.69 0 01-2.48-.94l.76-.91a2.66 2.66 0 001.74.71c.53 0 .85-.21.85-.55 0-.32-.2-.49-1.18-.74-1.18-.3-1.93-.62-1.93-1.78a1.82 1.82 0 012-1.76 3.41 3.41 0 012.17.74l-.67 1a2.76 2.76 0 00-1.52-.58c-.49 0-.75.23-.75.51 0 .38.25.51 1.26.77 1.19.31 1.85.73 1.85 1.75.01 1.13-.84 1.78-2.1 1.78zM93.36 18v-5.81h4.4v1.15h-3.12v1.18h2.75v1.14h-2.75v1.23h3.17V18zM43.16 30.91l4.48-7.35h1.67v12.28h-2.37V29L44 33.82h-1.66l-3-4.82v6.84H37V23.56h1.67zM52.82 35.84l5.27-12.28h1.66L65 35.84h-2.46l-1.16-2.72h-4.93l-1.15 2.72zM57.35 31h3.12l-1.56-3.64zM70.9 30.4v5.44h-2.37V23.56H73a3.71 3.71 0 012.68.91 3.43 3.43 0 010 5 3.13 3.13 0 01-1.23.72l4.6 5.63h-2.92l-4.37-5.42zm2-2.1a1.45 1.45 0 001.2-.37 1.44 1.44 0 000-1.88 1.45 1.45 0 00-1.2-.39h-2v2.64zM84.77 29.81v6H82.4V23.56h2.37v4.91l4.65-4.91h3.12l-5.41 5.61 6.06 6.67h-3zM99.07 25.66v2.55h3.78v2.1h-3.78v3.43h5.18v2.1H96.7V23.56h7.37v2.1zM116.62 23.56v2.1h-3.24v10.18H111V25.66h-3.25v-2.1zM120.58 23.56h2.36v12.28h-2.36zM127.86 23.56h1.67l6.84 8v-8h2.37v12.28h-1.67l-6.84-8v8h-2.37zM145.15 29.7a4.13 4.13 0 004.19 4.21 4.3 4.3 0 002.74-.95v-2.65h-3.16v-2.1h5.53v5.46a6.47 6.47 0 01-5.16 2.33 6.32 6.32 0 110-12.64 6.4 6.4 0 014.49 1.76l-1.53 1.61a4.18 4.18 0 00-3-1.26 4.1 4.1 0 00-4.1 4.23z"/></g></svg>';
			
			$global_styles = '
			:root {
				--highlight-color: var(--people-color);
			}
			
			/* Header */
			.header__logo-svg {
				width: 17rem;
			}
			
			@media screen and (max-width: 47.9375em) {
				
				.header__logo-svg {
					width: 14rem;
				}
				
			}
			';


elseif ($global_branding == 'Our education') :
		
			$global_logo = '<svg id="Layer_2" data-name="Layer 2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 145.36 43.23">
  <defs>
    <style>
      .cls-1 {
        fill: #fff;
      }

      .cls-2 {
        fill: #b3a462;
      }
    </style>
  </defs>
  <g id="full-rgb">
    <g id="type">
      <path id="type_CompoundPathItem_" data-name="type &amp;lt;CompoundPathItem&amp;gt;" class="cls-1" d="m38.25,16.86v-4.67h-1.28v5.84h4.19v-1.17h-2.91Z"/>
      <path id="type_CompoundPathItem_-2" data-name="type &amp;lt;CompoundPathItem&amp;gt;" class="cls-1" d="m43.4,12.19v5.84h1.28v-5.84h-1.28Z"/>
      <path id="type_CompoundPathItem_-3" data-name="type &amp;lt;CompoundPathItem&amp;gt;" class="cls-1" d="m50.2,12.09c-1.8,0-3.11,1.36-3.11,3.02v.02c0,1.66,1.3,3,3.1,3s3.11-1.36,3.11-3.02h0c0-1.67-1.29-3.02-3.1-3.02Zm1.76,3.04c0,1-.72,1.82-1.76,1.82s-1.76-.84-1.76-1.84h0c0-1.01.71-1.83,1.75-1.83s1.77.83,1.77,1.83v.02Z"/>
      <path id="type_CompoundPathItem_-4" data-name="type &amp;lt;CompoundPathItem&amp;gt;" class="cls-1" d="m59.57,12.19v3.6l-2.74-3.6h-1.18v5.84h1.27v-3.71l2.83,3.71h1.09v-5.84h-1.27Z"/>
      <path id="type_CompoundPathItem_-5" data-name="type &amp;lt;CompoundPathItem&amp;gt;" class="cls-1" d="m67.1,12.19v2.31h-2.37v-2.31h-1.28v5.84h1.28v-2.34h2.37v2.34h1.29v-5.84h-1.29Z"/>
      <path id="type_CompoundPathItem_-6" data-name="type &amp;lt;CompoundPathItem&amp;gt;" class="cls-1" d="m73.85,12.09c-1.8,0-3.11,1.36-3.11,3.02v.02c0,1.66,1.29,3,3.09,3s3.11-1.36,3.11-3.02h0c0-1.67-1.29-3.02-3.09-3.02Zm1.75,3.04c0,1-.72,1.82-1.75,1.82s-1.77-.84-1.77-1.84h0c0-1.01.72-1.83,1.75-1.83s1.77.83,1.77,1.83v.02Z"/>
      <path id="type_CompoundPathItem_-7" data-name="type &amp;lt;CompoundPathItem&amp;gt;" class="cls-1" d="m83.01,12.19v3.35c0,.92-.48,1.4-1.26,1.4s-1.26-.49-1.26-1.44v-3.31h-1.29v3.34c0,1.72.96,2.59,2.53,2.59s2.56-.86,2.56-2.63v-3.3h-1.28Z"/>
      <path id="type_CompoundPathItem_-8" data-name="type &amp;lt;CompoundPathItem&amp;gt;" class="cls-1" d="m89.18,14.54c-1.01-.26-1.26-.39-1.26-.77v-.02c0-.28.26-.51.75-.51s1,.22,1.52.58l.66-.97c-.59-.47-1.31-.74-2.16-.74-1.2,0-2.05.7-2.05,1.76v.02c0,1.16.76,1.48,1.94,1.78.97.25,1.17.42,1.17.74v.02c0,.34-.31.55-.84.55-.67,0-1.22-.27-1.74-.71l-.76.91c.7.63,1.59.94,2.48.94,1.26,0,2.14-.65,2.14-1.81v-.02c0-1.02-.67-1.44-1.85-1.75Z"/>
      <path id="type_CompoundPathItem_-9" data-name="type &amp;lt;CompoundPathItem&amp;gt;" class="cls-1" d="m94.63,16.89v-1.23h2.75v-1.14h-2.75v-1.18h3.13v-1.15h-4.4v5.84h4.44v-1.14h-3.17Z"/>
    </g>
    <g id="logoMark">
      <path id="logoMark_CompoundPathItem_" data-name="logoMark &amp;lt;CompoundPathItem&amp;gt;" class="cls-2" d="m0,12.23v24.76l12.81,6.24,12.78-6.24V12.23H0Zm12.81,29.5l-11.45-5.59V14.52l22.39,21.86-10.94,5.35Zm11.43-6.77L2.35,13.59h21.89v21.37Z"/>
      <path id="logoMark_CompoundPathItem_-2" data-name="logoMark &amp;lt;CompoundPathItem&amp;gt;" class="cls-2" d="m13.49,7.87v-1.15l3.01-3.01-3.7-3.71-3.7,3.71,3.03,3.03v1.13h-6.99v1.36h15.32v-1.36h-6.97Zm-2.47-4.16l1.78-1.79,1.78,1.79-1.78,1.78-1.78-1.78Z"/>
    </g>
    <g>
      <path class="cls-1" d="m36.6,35.94v-12.6h8.64v2.27h-6.31v2.88h4.16v2.2h-4.16v2.99h6.38v2.27h-8.71Z"/>
      <path class="cls-1" d="m48.95,35.94v-12.6h4.32c.84,0,1.62.16,2.34.49.73.32,1.36.77,1.89,1.33.53.56.95,1.24,1.25,2.02.31.78.46,1.61.46,2.5s-.15,1.7-.46,2.47c-.31.77-.72,1.43-1.25,1.99-.53.56-1.16,1-1.89,1.32-.73.32-1.51.49-2.34.49h-4.32Zm4.3-10.28h-1.98v7.96h1.98c.49,0,.96-.1,1.39-.31.43-.2.81-.48,1.13-.84.32-.35.57-.77.75-1.25.18-.48.27-1,.27-1.55s-.09-1.09-.27-1.58c-.18-.49-.43-.92-.75-1.28-.32-.36-.7-.64-1.13-.85-.43-.2-.9-.31-1.39-.31Z"/>
      <path class="cls-1" d="m72.58,30.49c0,.85-.12,1.63-.35,2.33-.24.7-.57,1.3-1,1.78-.43.49-.96.86-1.57,1.12-.62.26-1.3.4-2.05.4s-1.45-.13-2.06-.4c-.62-.26-1.14-.64-1.57-1.12-.43-.49-.76-1.08-1-1.77-.24-.7-.35-1.48-.35-2.34v-7.15h2.33v7.15c0,.97.24,1.75.73,2.34.49.59,1.13.88,1.94.88s1.44-.29,1.92-.88c.48-.59.71-1.37.71-2.34v-7.15h2.33v7.15Z"/>
      <path class="cls-1" d="m82.05,33.71c.59,0,1.14-.14,1.65-.41.51-.28.97-.67,1.37-1.19l1.53,1.69c-.54.71-1.22,1.27-2.05,1.69-.83.42-1.68.63-2.56.63s-1.64-.17-2.37-.5c-.73-.34-1.37-.79-1.9-1.37-.54-.58-.96-1.26-1.26-2.05-.31-.79-.46-1.64-.46-2.56s.16-1.77.47-2.57c.31-.8.73-1.49,1.27-2.06.54-.58,1.17-1.03,1.9-1.37.73-.34,1.52-.5,2.35-.5.9,0,1.77.21,2.62.64.85.43,1.53,1,2.06,1.72l-1.57,1.75c-.4-.55-.86-.97-1.4-1.27-.54-.29-1.1-.44-1.7-.44-.5,0-.98.11-1.42.31-.44.21-.83.5-1.15.86-.32.37-.57.8-.75,1.3-.18.5-.27,1.04-.27,1.63s.09,1.11.28,1.61c.19.5.44.93.77,1.29.33.36.71.65,1.16.85.44.21.93.32,1.45.32Z"/>
      <path class="cls-1" d="m88.88,35.94l4.63-12.6h2.7l4.56,12.6h-2.52l-1.14-3.31h-4.64l-1.16,3.31h-2.43Zm4.3-5.4h3.21l-1.59-4.64-1.62,4.64Z"/>
      <path class="cls-1" d="m100.78,25.65v-2.3h9.89v2.3h-3.77v10.3h-2.33v-10.3h-3.79Z"/>
      <path class="cls-1" d="m113.97,35.94v-12.6h2.33v12.6h-2.33Z"/>
      <path class="cls-1" d="m131.79,29.64c0,.9-.16,1.75-.47,2.55-.31.8-.73,1.49-1.26,2.07-.53.58-1.16,1.04-1.89,1.38-.73.34-1.51.5-2.34.5s-1.6-.17-2.33-.5c-.73-.34-1.36-.79-1.89-1.38-.53-.58-.95-1.27-1.26-2.07-.31-.8-.47-1.65-.47-2.55s.16-1.75.47-2.55c.31-.8.73-1.49,1.26-2.07.53-.58,1.16-1.04,1.89-1.38.73-.34,1.5-.5,2.33-.5s1.62.17,2.34.5c.73.34,1.36.8,1.89,1.38.53.58.95,1.27,1.26,2.07.31.8.47,1.65.47,2.55Zm-2.39,0c0-.59-.09-1.13-.27-1.63-.18-.5-.43-.93-.75-1.3-.32-.37-.69-.65-1.13-.86-.44-.21-.91-.31-1.41-.31s-.97.11-1.41.31c-.43.21-.81.5-1.12.86-.32.37-.56.8-.75,1.3-.18.5-.27,1.04-.27,1.63s.09,1.12.27,1.62c.18.5.43.94.75,1.3.32.37.69.65,1.12.86.43.21.9.32,1.41.32s.97-.1,1.41-.32c.44-.21.82-.5,1.13-.86.32-.37.56-.8.75-1.3.18-.5.27-1.04.27-1.62Z"/>
      <path class="cls-1" d="m135.37,23.34h2.22l5.59,8.15v-8.15h2.18v12.6h-2.06l-5.73-8.42v8.42h-2.2v-12.6Z"/>
    </g>
  </g>
</svg>';
			
			$global_styles = '
			:root {
				--highlight-color: var(--people-color);
			}
			
			/* Header */
			.header__logo-svg {
				width: 15rem;
			}
			
			@media screen and (max-width: 47.9375em) {
				
				.header__logo-svg {
					width: 10rem;
				}
				
			}
			';

elseif ($global_branding == 'Fitness') :
		
			$global_logo = '<svg id="Layer_2" data-name="Layer 2" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 394.5 235.5">
  <g id="Layer_1-2" data-name="Layer 1">
    <image width="526" height="314" transform="scale(.75)" xlink:href="data:image/png;base64,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"/>
  </g>
</svg>';
			
			$global_styles = '
			:root {
				--highlight-color: var(--people-color);
			}
			
			/* Header */
			.header__logo-svg {
				width: 15rem;
			}
			
			@media screen and (max-width: 47.9375em) {
				
				.header__logo-svg {
					width: 10rem;
				}
				
			}
			';



		elseif ($global_branding == 'Support') :
		
			$global_logo = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 322.72 111.07" aria-label="LionHouse Support logo" class="header__logo-svg"><g class="header__logo-type"><path d="M98.43 43.41v-12h-3.31v15h10.79v-3zM111.66 31.39v15H115v-15zM129.18 31.13a7.78 7.78 0 00-8 7.76 8 8 0 0016 0 7.69 7.69 0 00-8-7.76zm4.49 7.81a4.48 4.48 0 01-4.49 4.68 4.57 4.57 0 01-4.55-4.73 4.5 4.5 0 014.5-4.68 4.56 4.56 0 014.54 4.73zM153.27 31.39v9.25l-7-9.25h-3.06v15h3.26v-9.53l7.3 9.56h2.8v-15zM172.67 31.39v5.93h-6.12v-5.93h-3.28v15h3.28v-6h6.12v6H176v-15zM190 31.13a7.76 7.76 0 00-8 7.76 7.69 7.69 0 008 7.73 7.78 7.78 0 008-7.78 7.67 7.67 0 00-8-7.71zm4.52 7.81a4.5 4.5 0 01-4.52 4.68 4.58 4.58 0 01-4.55-4.73 4.5 4.5 0 014.55-4.73 4.58 4.58 0 014.55 4.73zM213.59 31.39V40c0 2.39-1.24 3.6-3.27 3.6s-3.23-1.26-3.23-3.7v-8.5h-3.29V40c0 4.42 2.47 6.68 6.5 6.68s6.57-2.24 6.57-6.78v-8.51zM229.46 37.4c-2.59-.64-3.24-1-3.24-1.95v-.05c0-.72.65-1.31 1.93-1.31a7.07 7.07 0 013.91 1.49l1.72-2.5a8.71 8.71 0 00-5.6-1.92c-3.06 0-5.24 1.82-5.24 4.54 0 3 1.95 3.83 5 4.6 2.49.64 3 1.08 3 1.9v.05c0 .87-.8 1.41-2.16 1.41a6.86 6.86 0 01-4.5-1.82l-2 2.34a9.58 9.58 0 006.4 2.41c3.23 0 5.49-1.67 5.49-4.65.04-2.64-1.68-3.74-4.71-4.54zM243.49 43.46V40.3h7.09v-2.93h-7.09v-3h8v-2.98H240.2v15h11.45v-3zM94.49 84.32a10.42 10.42 0 007.44 3.47c2.7 0 4.6-1.66 4.6-4 0-4.06-5.86-4.56-10.1-7C94 75.35 92 73.19 92 69.63c0-5.64 5.18-8.88 10.41-8.88a14.65 14.65 0 019.15 3l-3.16 4.51a8.42 8.42 0 00-5.45-2.07c-2.3 0-4.87 1-4.87 3.42 0 5.1 14.56 3.52 14.56 14.16 0 5.59-5 9.46-10.68 9.46a16.82 16.82 0 01-11.4-4.73zM126.82 90c-2.61-2.35-4-5.68-4-10.51V61.2h6.08v18.71c0 2.88.77 4.64 2.07 5.86a8.13 8.13 0 0010.73 0c1.31-1.22 2.07-3 2.07-5.86V61.2h6.09v18.25c0 4.83-1.44 8.16-4.06 10.51a15.45 15.45 0 01-18.93 0zM168.3 79.91v12.84h-6.09V61.2h11.86c4.06 0 6.45 1 8.2 2.84a9.85 9.85 0 010 13.07c-1.71 1.8-4.14 2.8-8.2 2.8zm5.5-5.41c2.07 0 3.11-.5 3.83-1.26a3.81 3.81 0 001-2.67 3.88 3.88 0 00-1-2.7c-.72-.77-1.76-1.26-3.83-1.26h-5.5v7.89zM200.54 79.91v12.84h-6.09V61.2h11.86c4.05 0 6.45 1 8.2 2.84a9.85 9.85 0 010 13.07c-1.71 1.8-4.15 2.8-8.2 2.8zM206 74.5c2.07 0 3.11-.5 3.83-1.26a3.81 3.81 0 001-2.67 3.88 3.88 0 00-1-2.7c-.72-.77-1.76-1.26-3.83-1.26h-5.5v7.89zM242.24 60.75C252 60.75 258.7 68 258.7 77s-6.7 16.2-16.46 16.2S225.79 86 225.79 77s6.72-16.25 16.45-16.25zm0 27c6 0 10.37-4.86 10.37-10.81s-4.41-10.82-10.37-10.82S231.88 71 231.88 77s4.41 10.79 10.36 10.79zM275.16 78.78v14h-6.08V61.2h11.49a9.57 9.57 0 016.9 2.34 8.84 8.84 0 010 12.89 8 8 0 01-3.16 1.85l11.81 14.47h-7.53l-11.22-14zm5-5.41c1.76 0 2.52-.36 3.06-1a3.61 3.61 0 00.9-2.39 3.68 3.68 0 00-.9-2.43c-.54-.59-1.3-1-3.06-1h-5v6.76zM322.72 61.2v5.41h-8.33v26.14h-6.09V66.61H300V61.2z"/></g><g class="header__logo-icon"><path d="M0 31.44V95l32.9 16 32.83-16V31.44zm62.27 3.47v31.2H34.65v-31.2zm-58.78-.1h27.67v31.28H3.49zm27.67 71.53L3.49 92.83V69.59h27.67zm3.49 0V69.59h27.62v23.24zM52.56 20.22H34.65v-3l7.73-7.73L32.88 0l-9.5 9.53 7.78 7.78v2.91h-18v3.49h39.4zM28.31 9.53l4.57-4.6 4.57 4.6-4.57 4.57z"/></g></svg>';
			
			$global_styles = '
			:root {
				--highlight-color: var(--support-color);
			}
			
			/* Header */
			.header__logo-svg {
				width: 13.5rem;
			}
			
			@media screen and (max-width: 47.9375em) {
				
				.header__logo-svg {
					width: 10rem;
				}
				
			}
			';

		
		endif;
				
	endif;
	
	$GLOBALS['global-logo'] = $global_logo;
	$GLOBALS['global-styles'] = $global_styles;
	
	add_action('wp_head', 'my_custom_styles', 100);
	function my_custom_styles()	{
		echo '<style>' . $GLOBALS['global-styles'] . '</style>';
	}
	
	function article_search_q( $qry ) {
    if ( $qry->is_main_query() AND $qry->is_home() AND isset($_GET['search']) ) {
      $qry->set('s', $_GET['search']);
      $qry->set('posts_per_page', 4);
    }
	}
	add_action('pre_get_posts', 'article_search_q');
	
	// Add a shortcodes dropdown ion the editor
	// hooks your functions into the correct filters
	function wdm_add_mce_button() {
		// check user permissions
		if ( !current_user_can( 'edit_posts' ) &&  !current_user_can( 'edit_pages' ) ) {
			return;
		}
		// check if WYSIWYG is enabled
		if ( 'true' == get_user_option( 'rich_editing' ) ) {
			add_filter( 'mce_external_plugins', 'wdm_add_tinymce_plugin' );
			add_filter( 'mce_buttons', 'wdm_register_mce_button' );
		}
	}
	add_action('admin_head', 'wdm_add_mce_button');
	
	// register new button in the editor
	function wdm_register_mce_button( $buttons ) {
		array_push( $buttons, 'wdm_mce_dropbutton' );
		return $buttons;
	}
		
	// declare a script for the new button
	// the script will insert the shortcode on the click event
	function wdm_add_tinymce_plugin( $plugin_array ) {
		$plugin_array['wdm_mce_dropbutton'] = get_stylesheet_directory_uri() .'/library/js/shortcodes.js';
		return $plugin_array;
	}
	
	// Add arrow button shortcode
	function create_sc_arrow_btn($atts) {
		
		$atts = shortcode_atts( array(
			'copy' => 'Copy',
			'link' => 'https://example.com/',
			'newwindow' => 'No'
		), $atts, 'arrow-btn' );
		
		if ($atts['newwindow'] == 'yes' OR $atts['newwindow'] == 'Yes' OR $atts['newwindow'] == 'YES') :
			$target = " target='_blank'";
		else :
			$target = null;
		endif;
		
		$return = '<a href="' . $atts['link'] . '"' . $target . ' class="arrow-btn">';
		
		if ($atts['copy']) :
			$return .= '<span class="arrow-btn__copy type-h6">' . $atts['copy'] . '</span>';
		endif;
		
		$return .= '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44.97 25.97" class="arrow-btn__svg" aria-label="Right icon" width="30"><g fill="none" stroke-width="2"><path d="M30.28 3.71L39.56 13l-9.28 9.28"/><path d="M39.56 13H4"/></g></svg></a>';
		
		return $return;

  }
	add_shortcode('arrow-btn', 'create_sc_arrow_btn');
	
	// Add contact form shortcode
	function create_sc_contact_form($atts) {
		
		$global_form_success_message = get_field('global_form_success_message', 'options');
		
		return '<form class="contact-form margin-top-xs-3 margin-top-sm-5" action="' . get_the_permalink() . '" method="post">
				<ul class="contact-form__fields no-list">
					<li class="contact-form__field contact-form__field--half">
						<label for="fname" class="vis-hidden">First Name*</label>
						<input type="text" id="fname" name="fname" required placeholder="First Name*">
					</li>
					<li class="contact-form__field contact-form__field--half">
						<label for="lname" class="vis-hidden">Last Name*</label>
						<input type="text" id="lname" name="lname" required placeholder="Last Name*">
					</li>
					<li class="contact-form__field contact-form__field--half">
						<label for="email" class="vis-hidden">Email*</label>
						<input type="email" id="email" name="email" required placeholder="Email*">
					</li>
					<li class="contact-form__field contact-form__field--half">
						<label for="phone" class="vis-hidden">Phone*</label>
						<input type="tel" name="phone" required placeholder="Phone*">
					</li>
					<li class="contact-form__field">
						<label for="message" class="vis-hidden">Message*</label>
						<textarea id="message" name="message" required placeholder="Message*"></textarea>
					</li>
					<li class="contact-form__field">
						<input type="text" name="hduuss" class="vis-hidden">
						<input type="hidden" name="action" value="send_contact_form">
						<button type="submit" class="arrow-btn"><span class="arrow-btn__copy type-h6">Submit</span><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44.97 25.97" class="arrow-btn__svg" aria-label="Right icon" width="30"><g fill="none" stroke-width="2"><path d="M30.28 3.71L39.56 13l-9.28 9.28"/><path d="M39.56 13H4"/></g></svg></button>
						<div class="contact-form__success type-mustard">
							<p class="margin-top-xs-2"><b>' . $global_form_success_message . '</b></p>
						</div>
					</li>
				</ul>
			</form>';

  }
	add_shortcode('contact-form', 'create_sc_contact_form');
	
	// Add a new toolbar
  add_filter( 'acf/fields/wysiwyg/toolbars', 'my_toolbars'  );
	function my_toolbars( $toolbars ) {
		// Add a new toolbar called "Very Simple"
		$toolbars['Very Basic'] = array();
		$toolbars['Very Basic'][1] = array('styleselect', 'bold', 'italic', 'bullist', 'numlist', 'underline', 'superscript', 'subscript', 'link', 'unlink', 'hr', 'blockquote', 'wdm_mce_dropbutton' );
		
		return $toolbars;
	}
  
?>