<!DOCTYPE HTML>
<html <?php language_attributes(); ?>>

<head>

	<meta charset="<?php bloginfo('charset'); ?>">

	<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">

	<title><?= wp_title() ?></title>
	<meta name="title" content="<?= wp_title() ?>">
	<meta name="description" content="<?= get_bloginfo('description') ?>">

	<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0">

	<link rel="preload" href="<?=get_stylesheet_directory_uri()?>/library/fonts/Brown-Regular.woff2" as="font" crossorigin>
	<link rel="preload" href="<?=get_stylesheet_directory_uri()?>/library/fonts/Brown-Light.woff2" as="font" crossorigin>
	<link rel="preload" href="<?=get_stylesheet_directory_uri()?>/library/fonts/Brown-Bold.woff2" as="font" crossorigin>
	
	<script>
		window.lazySizesConfig = window.lazySizesConfig || {};
		lazySizesConfig.preloadAfterLoad = true;
	</script>
	
	<?php wp_head(); ?>
	
</head>

<body <?php body_class(); ?>>

	<div class="header-bg" aria-hidden="true" id="header-bg" data-turbolinks-permanent></div>
	<header class="header" id="header" data-turbolinks-permanent>
		<div class="row row--lg">
			<div class="col header__wrap">
				<a href="<?=home_url('/')?>" class="header__logo"><?=$GLOBALS['global-logo']?></a>
				<button class="header__nav-toggle" type="button"><div></div><div></div><div></div></button>
			</div>
			
	
		</div>
	</header>
	
	<nav class="header-nav" id="header-nav" data-turbolinks-permanent>
		<div class="header-nav__wrap row">
			<ul class="col col-sm-5 header-nav__listing type-white">
				<?php header_nav() ?>
			</ul>
		</div>
	</nav>
	
	<main class="main-content">