<?php
	
	if (is_home() OR is_category()) :
		$page_ID = get_option('page_for_posts');
	else :
		$page_ID = get_the_ID();
	endif;
	
	$pb_height = get_field('pb_height', $page_ID);
	
	if ($pb_height == 'Half') :
		$pb_height_class = ' full-height-block--half';
	elseif ($pb_height == 'Third') :
		$pb_height_class = ' full-height-block--third';
	else :
		$pb_height_class = '';
	endif;
	
	$pb_slides_count = @count(get_field('pb_slides', $page_ID));
	
	if( have_rows('pb_slides', $page_ID) ):
?>
<section class="full-height-block<?=$pb_height_class?> section--dark">
	<?php if ($pb_slides_count > 1) : ?>
	<button type="button" class="full-height-block__btn full-height-block__btn--left" disabled="true"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44.97 25.97" class="full-height-block__btn-svg" aria-label="Left icon" width="30"><g fill="none" stroke-width="2"><path d="M13.28 22.27L4 13l9.28-9.28"/><path d="M4 13h35.56"/></g></svg></button>
	<button type="button" class="full-height-block__btn full-height-block__btn--right"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44.97 25.97" class="full-height-block__btn-svg" aria-label="Left icon" width="30"><g fill="none" stroke-width="2"><path d="M30.28 3.71L39.56 13l-9.28 9.28"/><path d="M39.56 13H4"/></g></svg></button>
	<?php endif; ?>
	<div<?=$pb_slides_count > 1 ? ' class="full-height-block__slider"' : ''?>>
		<?php
			while( have_rows('pb_slides', $page_ID) ) : the_row();
				$pb_slides_background_type = get_sub_field('pb_slides_background_type');
				$pb_slides_image = get_sub_field('pb_slides_image');
				$pb_slides_video = get_sub_field('pb_slides_video');
				$pb_slides_heading = get_sub_field('pb_slides_heading');
				$pb_slides_sub_heading = get_sub_field('pb_slides_sub_heading');
		?>
		<div class="full-height-block__slide<?=$pb_slides_background_type == 'Video' ? ' full-height-block__slide--video' : '' ?><?=$pb_slides_background_type == 'Image' ? ' lazyimage lazyload' : ''?><?=$pb_slides_background_type == 'Color' ? ' bg-highlight' : ''?>"<?php if ($pb_slides_background_type == 'Image') : ?> data-bg="<?=$pb_slides_image['sizes']['large']?>"<?php endif; ?>>
			<div class="row full-height-block__wrap copy-block type-white pad-top-sm-6 pad-btm-sm-3 pad-top-xs-6 pad-btm-xs-3">
				<div class="col full-height-block__col">
					<?php if ($pb_height != 'Third') : ?>
					<h1><?=$pb_slides_heading?></h1>
					<?php endif; ?>
					<?php if ($pb_height == 'Full') : ?>
					<h3><?=$pb_slides_sub_heading?></h3>
					<?php endif; ?>
					<?php if ($pb_height == 'Full') : ?>
					<button type="button" class="full-height-block__down-arrow"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 21.48 39.77" aria-label="Down arrow" class="full-height-block__down-arrow-svg"><g fill="none" stroke-width="2"><path d="M20 27.68L10.74 37l-9.28-9.32"/><path d="M10.74 37V1.4"/></g></svg></button>
					<?php endif; ?>
				</div>
				<?php if ($pb_slides_background_type == 'Video') : ?>
				<video class="full-height-block__video" autoplay muted loop playsinline src="<?=$pb_slides_video['url']?>"></video>
				<?php endif; ?>
			</div>
		</div>
		<?php endwhile; ?>
	</div>
</section>
<?php endif; ?>