<?php get_header(); ?>

<?php if (have_posts()) : ?>
<?php @$current_cat = get_queried_object(); ?>

<?php if (!@$current_cat->name AND !isset($_GET['search'])) : ?>
<?= get_template_part('includes/page-banner') ?>
<?php endif; ?>

<section class="section--dark">
	<div class="row pad-top-sm-6 pad-btm-sm-4 pad-top-xs-3 pad-btm-xs-1">
		<div class="col">
			<div class="voice-filter">
				<ul class="voice-filter__listing">
					<li class="voice-filter__listing-item voice-filter__listing-item--search">
						<form action="<?=get_the_permalink(get_option('page_for_posts'))?>" method="get">
							<label class="type-p type-blue" for="search">Search</label>
							<input type="text" id="search" name="search" placeholder="Search Blog"<?=isset($_GET['search']) ? ' value=' . $_GET['search'] : ''?>>
						</form>
					</li>
					<li class="voice-filter__listing-item">
						<label class="type-p type-blue" for="categories">Categories</label>
						<select id="categories" name="categories">
							<option value="<?=get_the_permalink(get_option('page_for_posts'))?>">All</option>
							<?php
								$cats = get_categories();
								foreach ($cats as $cat) :
							?>
							<option value="<?=get_category_link($cat)?>"<?=@$current_cat->slug == $cat->slug ? ' selected="true"' : ''?>><?=$cat->name?></option>
							<?php endforeach; ?>
						</select>
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 21.97 15.4" class="voice-filter__listing-item-icon"><path d="M20.27 2.71L11 12 1.71 2.71" fill="none" stroke-width="2"/></svg>
					</li>
					<?php /*<li class="voice-filter__listing-item">
						<label class="type-p type-blue" for="sortby">Sort by</label>
						<select id="sortby" name="sortby">
							<option>Date Added</option>
							<option>Videos</option>
							<option>Videos</option>
							<option>Videos</option>
							<option>Videos</option>
						</select>
						<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 21.97 15.4" class="voice-filter__listing-item-icon"><path d="M20.27 2.71L11 12 1.71 2.71" fill="none" stroke-width="2"/></svg>
					</li>*/ ?>
				</ul>
			</div>
		</div>
	</div>
</section>

<section class="pad-btm-sm-6 pad-btm-xs-4 section--dark">
	<div class="row">
		<div class="col">
			<div class="voice-heading">
				<h1 class="type-bold type-h5 type-mustard"><?php if (isset($_GET['search'])) : ?>Searching for '<?=$_GET['search']?>'<?php elseif (@$current_cat->name) : ?>Category: <?=$current_cat->name?><?php else : ?>Latest News<?php endif; ?></h1>
			</div>
		</div>
	</div>	
	<?php
		$i = 0;
		while (have_posts()) : the_post();
			$i++;
			$article_excerpt = get_field('article_excerpt');
			$article_featured_media_type = get_field('article_featured_media_type');
			$article_featured_image = get_field('article_featured_image');
			$article_featured_video_embed = get_field('article_featured_video_embed');
			$article_featured_media_band_color = get_field('article_featured_media_band_color');
			
			if ($article_featured_media_band_color == 'Gold') :
				$article_featured_media_band_color_class = ' bg-mustard';
			elseif ($article_featured_media_band_color == 'Dark blue') :
				$article_featured_media_band_color_class = ' bg-blue';
			elseif ($article_featured_media_band_color == 'Blue') :
				$article_featured_media_band_color_class = ' bg-accounting';
			elseif ($article_featured_media_band_color == 'Orange') :
				$article_featured_media_band_color_class = ' bg-people';
			elseif ($article_featured_media_band_color == 'Red') :
				$article_featured_media_band_color_class = ' bg-commercial';
			elseif ($article_featured_media_band_color == 'Green') :
				$article_featured_media_band_color_class = ' bg-legal';
			elseif ($article_featured_media_band_color == 'Purple') :
				$article_featured_media_band_color_class = ' bg-support';
	  		elseif ($article_featured_media_band_color == 'Yellow') :
				$article_featured_media_band_color_class = ' bg-fitness';
			endif;
			
			if (!$paged AND $i == 1) :
	?>
	<div class="row">
		<article class="col voice-featured pad-btm-sm-0 pad-btm-xs-1">
			<h2 class="voice-featured__heading"><?=get_the_title()?></h2>
			<a href="<?=get_the_permalink()?>" class="arrow-btn voice-featured__more"><span class="arrow-btn__copy type-h6">Read More</span><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44.97 25.97" class="arrow-btn__svg" aria-label="Right icon" width="30"><g fill="none" stroke-width="2"><path d="M30.28 3.71L39.56 13l-9.28 9.28"/><path d="M39.56 13H4"/></g></svg></a>
			<a href="<?=get_the_permalink()?>" class="featured-media last-sm first-xs">
				<div class="featured-media__img">
					<?php if ($article_featured_media_type == 'Video') : ?>
					<span class="video-btn"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 111.06 111.06" class="video-btn__svg" aria-label="Play icon" width="30"><g fill="none" stroke-width="2"><ellipse cx="55.53" cy="55.53" rx="51.94" ry="52.42"/><path d="M46.35 39.42l24.49 17.84-24.49 17.83z"/></g></svg></span>
					<?php endif; ?>
					<figure class="lazyimage lazyimage--img lazyload" data-bg="<?=$article_featured_image['sizes']['large']?>">
						<img data-src="<?=$article_featured_image['sizes']['large']?>" alt="<?=$article_featured_image['alt']?>" class="vis-hidden lazyload lazyimage" />
					</figure>
				</div>
				<span class="featured-media__band<?=$article_featured_media_band_color_class?>" aria-hidden="true"></span>
			</a>
		</article>
	</div>
		
	<?php else : ?>
	
	<article class="row voice-article<?=($paged AND $i == 1) ? ' voice-article--first' : ''?> pad-btm-sm-0 pad-btm-xs-1">
		<div class="col col-sm-6 copy-block">
			<span class="type-mustard type-sm voice-article__date"><?=human_time_diff( get_the_time( 'U' ), current_time( 'timestamp' ) ).' '.__( 'ago' )?></span>
			<h2><?=get_the_title()?></h2>
			<?php if ($article_excerpt) : ?>
			<p><?=$article_excerpt?></p>
			<?php endif; ?>
			<a href="<?=get_the_permalink()?>" class="arrow-btn voice-article__more"><span class="arrow-btn__copy type-h6">Read More</span><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44.97 25.97" class="arrow-btn__svg" aria-label="Right icon" width="30"><g fill="none" stroke-width="2"><path d="M30.28 3.71L39.56 13l-9.28 9.28"/><path d="M39.56 13H4"/></g></svg></a>
		</div>
		<div class="col col-sm-6 first-xs last-sm pad-btm-sm-0 pad-btm-xs-1">
			<a href="<?=get_the_permalink()?>" class="featured-media">
				<div class="featured-media__img">
					<figure class="lazyimage lazyimage--img lazyload" data-bg="<?=$article_featured_image['sizes']['medium']?>">
						<img data-src="<?=$article_featured_image['sizes']['medium']?>" alt="<?=$article_featured_image['alt']?>" class="vis-hidden lazyload lazyimage" />
					</figure>
				</div>
				<span class="featured-media__band bg-people" aria-hidden="true"></span>
			</a>
		</div>
	</article>
	
	<?php endif; ?>
	
	<?php endwhile; ?>
	
	<?php
		$next_link = get_next_posts_link();
		$prev_link = get_previous_posts_link();
		if ($prev_link OR $next_link) :
	?>
	<div class="row pad-top-xs-3">
		<div class="col">
			<div class="voice-nav">
				<?php if ($prev_link) : ?>
				<a href="<?=get_previous_posts_page_link()?>" class="arrow-btn arrow-btn--back voice-nav__btn voice-nav__btn--back"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44.97 25.97" class="arrow-btn__svg" aria-label="Left icon" width="30"><g fill="none" stroke-width="2"><path d="M13.28 22.27L4 13l9.28-9.28"/><path d="M4 13h35.56"/></g></svg><span class="arrow-btn__copy type-p">Back</span></a>
				<?php endif; ?>
				<?php if ($next_link) : ?>
				<a href="<?=get_next_posts_page_link()?>" class="arrow-btn voice-nav__btn voice-nav__btn--next"><span class="arrow-btn__copy type-p">Next</span><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44.97 25.97" class="arrow-btn__svg" aria-label="Right icon" width="30"><g fill="none" stroke-width="2"><path d="M30.28 3.71L39.56 13l-9.28 9.28"/><path d="M39.56 13H4"/></g></svg></a>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<?php endif; ?>
</section>

<?php endif; ?>

<?php get_footer(); ?>
