var a, s,
LH = {
  
  elements: {
	  headerBg: document.querySelector('.header-bg'),
    header: document.querySelector('.header'),
    headerLogoSvg: document.querySelector('.header__logo-svg'),
    headerLogoType: document.querySelector('.header__logo-type'),
	  headerNavToggle: document.querySelector('.header__nav-toggle'),
	  headerNavToggle1: document.querySelector('.header__nav-toggle div:nth-child(1)'),
	  headerNavToggle2: document.querySelector('.header__nav-toggle div:nth-child(2)'),
	  headerNavToggle3: document.querySelector('.header__nav-toggle div:nth-child(3)'),
	  headerNav: document.querySelector('.header-nav'),
	  headerNavListItem: document.querySelectorAll('.header-nav__item'),
	  headerNavLinks: document.querySelectorAll('.header-nav__item-link'),
	  overlay: document.querySelector('.overlay--video'),
	  overlayClose: document.querySelector('.overlay__close-btn')
  },
  
  settings: {
    tl: new TimelineMax(),
    ltl: new TimelineMax(),
    menuOpen: false,
    overlayOpen: false,
    transition: false,
    visited: true
  },

  init: function() {
	  a = this.elements;
    s = this.settings;
    this.main();
    this.menu();
    this.scrollEvent();
    this.overlay();
    this.setMenuActive();
    
    this.search();
    this.sliders();
    this.tabs();
    this.fullHeightBlock();
    this.videoOverlays();
    this.enquireOverlays();
    this.voiceFiltering();
    this.contactForm();
    fitVids('.main-content');
  },

  main: function() {
	  
    void document.body.offsetWidth;
        
    window.scroll({ top: 0, left: 0, behavior: 'smooth' })
    				
		document.addEventListener("turbolinks:before-visit", function(e) {
			
	    var url = e.data.url;
	    
	    LH.setMenuActive(url);	    
	    
	    if (url != window.location.href) {
	    
		    if (!s.transition) {
			    
			    e.preventDefault();
			    
			    s.transition = true;
			    
			    s.tl
			    .to(a.headerBg, .5, { autoAlpha: 1, ease: 'Expo.inOut', onComplete: function(){
						Turbolinks.visit(url);
						if (s.menuOpen) {
					    LH.toggleMenu()
				    }
		      } })

		    }
	    
	    } else {
		    
		    e.preventDefault();
		    window.scroll({ top: 0, left: 0, behavior: 'smooth' });
		    
		    if (s.menuOpen) {
			    LH.toggleMenu()
		    }
		    		    
	    }
	      
		});
		
		document.addEventListener("turbolinks:visit", function(e) {
	    
	    s.transition = false;

		});
		
		document.addEventListener("turbolinks:load", function(e) {
						
			if (!e.data.timing.visitStart) {
				
				window.scroll({ top: 0, left: 0, behavior: 'smooth' });
				document.body.classList.add('overflow-hide');
				
				TweenMax.to(a.headerBg, .5, { delay: .5, autoAlpha: 0, ease: 'Expo.inOut', onComplete: function(){
					document.body.classList.remove('overflow-hide');
				} });
				
			} else {

	      TweenMax.to(a.headerBg, .5, { delay: .5, autoAlpha: 0, ease: 'Expo.inOut' });
				
			}
			
			if (window.location.href.includes('listings')) {
		    s.previousSearchURL = window.location.href;
		  }

			if (s.previousSearchURL) {
		    var t = document.querySelector('.voice-single__btr');
		    
		    if (t) {
			    t.innerHTML = 'Back to results';
			    t.href = s.previousSearchURL;
		    }
	    }
			
		})
			
		document.addEventListener("turbolinks:render", function(e) {
						
			LH.sliders();
			LH.search();
			LH.tabs();
		  LH.fullHeightBlock();
	    LH.videoOverlays();
	    LH.enquireOverlays();
	    LH.voiceFiltering();
	    LH.contactForm();
	    fitVids('.main-content');
	    	    		    
		});
			
  },
  
  menu: function(){
	  
	  a.headerNavToggle.addEventListener('click', function(){
			LH.toggleMenu();
	  });
	  
	  a.headerNavDDIcons = document.querySelectorAll('.header-nav__item-expand-btn');
	  
	  if (a.headerNavDDIcons.length) {
		  
		  a.headerNavDDIcons.forEach(function(n){
			  
			  var DDopen = false;
			  
			  n.addEventListener('click', function(){
				  
					DDopen = !DDopen;
					
					if (DDopen) {
				
						TweenMax.to(n, .25, { rotate: -180, ease: 'Power1.easeIn' });
						TweenMax.to(n.nextElementSibling, .25, { height: 'auto', ease: "Power1.easeIn" });
					  TweenMax.to(n.nextElementSibling, .325, { delay: .25, opacity: 1, ease: "Power1.easeIn", clearProps: 'all', onComplete: function(){
						  n.parentNode.classList.add('header-nav__item--subs-open');
					  } });
					  
				  } else {
					  
					  TweenMax.to(n, .25, { rotate: 0, ease: 'Power1.easeOut' });
					  TweenMax.to(n.nextElementSibling, .25, { height: 0, opacity: 0, ease: "Power1.easeOut", clearProps: 'all', onComplete: function(){
						  n.parentNode.classList.remove('header-nav__item--subs-open');
					  } });
					  
				  }
				  
			  })
			  
		  })
		  
	  }
	  
  },
  
  toggleMenu: function(){
	  
	  s.menuOpen = !s.menuOpen;
	  a.header.classList.toggle('header--menu-open');
	  
	  if (s.menuOpen) {

			document.body.classList.add('overflow-hide');
			
		  s.tl
		  .to(a.headerNavToggle1, .25, { y: 0, ease: 'Power1.easeOut' })
		  .to(a.headerNavToggle3, .25, { y: 0, ease: 'Power1.easeOut' }, '-=.25')
		  .fromTo(a.headerNav, .325, { x: '100%' }, { x: 0, ease: 'Expo.inOut' }, '-=.25')
		  
		  if (!s.scrolled) {
			  s.tl
			  .to(a.headerLogoSvg, .325, { scale: 1, ease: 'Expo.inOut' }, '-=.25')
			  .to(a.headerLogoType, .325, { autoAlpha: 0, ease: 'Expo.inOut' }, '-=.25')
		  }
		  s.tl
		  .set(a.headerNavToggle2, { opacity: 0 }, '-=.675')
		  .to(a.headerNavToggle1, .25, { rotate: -45, ease: 'Power1.easeOut' })
		  .to(a.headerNavToggle3, .25, { rotate: 45, ease: 'Power1.easeOut' }, '-=.25')
		  .staggerFromTo(a.headerNavListItem, .25, { opacity: 0, x: '-1rem' }, { opacity: 1, x: 0, clearProps: 'all', ease: 'Power1.easeOut' }, .05, '-=.325')
		  
	  } else {
		  
		  document.body.classList.remove('overflow-hide');
		  
		  s.tl
		  .staggerTo(a.headerNavListItem, .25, { opacity: 0, ease: 'Power1.easeOut' }, 0)
		  .to(a.headerNav, .325, { x: '-100%', ease: 'Expo.inOut' })
		  if (!s.scrolled) {
			  s.tl
			  .to(a.headerLogoType, .325, { autoAlpha: 1, ease: 'Expo.inOut' }, '-=.25')
			}
			s.tl
		  .to(a.headerNavToggle3, .25, { rotate: 0, ease: 'Power1.easeOut' }, '-=.325')
		  .to(a.headerNavToggle1, .25, { rotate: 0, ease: 'Power1.easeOut' }, '-=.325')
		  .set(a.headerNavToggle2, { opacity: 1 }, '-=.25')
		  .to(a.headerNavToggle3, .25, { y: '.5rem', ease: 'Power1.easeOut' })
		  .to(a.headerNavToggle1, .25, { y: '-.5rem', ease: 'Power1.easeOut', onComplete: function(){
			  s.scrolled = false;
		  } }, '-=.25')

	  }
	  	  
  },
  
  setMenuActive: function(url = window.location.href){
	  
	  a.headerNavLinks.forEach(function(t){
		  if (url == t.href) {
			  t.classList.add('header-nav__item-link--active')
		  } else {
			  t.classList.remove('header-nav__item-link--active')
		  }
	  })
	  
	  a.headerNavSubLinks = document.querySelectorAll('.header-nav__sub-item-link');
	  
	  if (a.headerNavSubLinks.length) {
		  		  
		  a.headerNavSubLinks.forEach(function(t){
			  if (url == t.href) {
				  t.classList.add('header-nav__sub-item-link--active')
			  } else {
				  t.classList.remove('header-nav__sub-item-link--active')
				  t.parentNode.parentNode.parentNode.querySelector('.header-nav__item-link').classList.remove('header-nav__item-link--active')
			  }
		  })
		  
		  a.headerNavSubLinks.forEach(function(t){
			  if (url == t.href) {
				  t.parentNode.parentNode.parentNode.querySelector('.header-nav__item-link').classList.add('header-nav__item-link--active')
			  }
		  })
	  }
	  
  },
  
  fullHeightBlock: function(){
	  
	  var o = document.querySelector('.full-height-block');
	  var h = document.querySelector('.full-height-block__down-arrow');
	  
	  if (h) {
		  
		  h.addEventListener('click', function(){
			  o.nextElementSibling.scrollIntoView({ 
				  behavior: 'smooth' 
				});
		  })
		  
	  }
	  
  },
  
  tabs: function(){
	  
	  var g = document.querySelectorAll('.fifty-block__img-col-tab');
	  	  
	  if (g.length) {
		  
		  var t = document.querySelectorAll('.fifty-block-tab');
		  
		  g.forEach(function(p){
			  
			  p.querySelector('button').addEventListener('click', function(){
				  
				  var slider = parseInt(this.dataset.tabslider);
				  var tab = parseInt(this.dataset.tab);
				  var theslider = document.querySelector('[data-tabsslider="'+slider+'"]');
					
					if (!p.classList.contains('fifty-block__img-col-tab--active')) {
						
						g.forEach(function(d){
						  d.classList.remove('fifty-block__img-col-tab--active');
						});
				  
					  p.classList.add('fifty-block__img-col-tab--active');
					  
					  var flkty = Flickity.data(theslider);
					  flkty.select(tab);
					  					  
					  TweenMax.to(theslider, .325, { height: 'auto', ease: "Power1.easeIn" });
					  TweenMax.to(theslider, .325, { delay: .325, opacity: 1, ease: "Power1.easeIn" });
					  					  
				  } else {
					  
					  g.forEach(function(d){
						  d.classList.remove('fifty-block__img-col-tab--active');
						});
					  
					  TweenMax.to(theslider, .325, { height: 0, opacity: 0, ease: "Power1.easeOut" });
					  
				  }				  
				  
			  })
			  
		  })
		  
	  }
	  
  },
  
  sliders: function(){
		
		var x = document.querySelectorAll('.slider-block');
	  
	  if (x.length) {
		  
		  x.forEach(function(l){
			  
			  var u = l.querySelector('.slider-block__slider');
				var j = l.querySelector('.slider-block__btn--left');
			  var r = l.querySelector('.slider-block__btn--right');
			  
			  var flktyInit = new Flickity(u, {
	        autoPlay: false,
					pageDots: false,
					draggable: true,
	        prevNextButtons: false,
	        cellAlign: 'left',
	        percentPosition: false
				});
				
				var flkty = Flickity.data(u);
	      
	      flkty.on( 'change', function(index) {
	        if (index == 0 && j) {
	          j.disabled = true;
	        } else {
	          j.disabled = false;
	        }
	
	        if (index == flkty.cells.length - 1 && r) {
	          r.disabled = true;
	        } else {
	          r.disabled = false;
	        }
	        
	      });
	      
	      if (j) {
		      j.addEventListener('click', function(){
		        flkty.previous(true, false);
					});
				}

				if (r) {
					r.addEventListener('click', function(){
		        flkty.next(true, false);
					});
				}
			  
		  });
		 
		}
		
		var y = document.querySelectorAll('.fifty-block-tabs-drop-down');
		
		if (y.length) {
			
			y.forEach(function(l){
				
				var flktyInit1 = new Flickity(l, {
	        autoPlay: false,
					pageDots: false,
					draggable: false,
	        prevNextButtons: false,
	        cellAlign: 'left',
	        percentPosition: false,
	        adaptiveHeight: true
				});
				
			});
			
		}
		
		var y = document.querySelectorAll('.column-slider');
		
		if (y.length) {
			
			y.forEach(function(l){
				var flktyInit1 = new Flickity(l, {
	        autoPlay: false,
					pageDots: false,
					draggable: true,
	        prevNextButtons: true,
	        cellAlign: 'left',
	        percentPosition: false,
	        groupCells: true
				});
				
			});
			
		}
		
		var y = document.querySelectorAll('.listing-slider__slider');
		
		if (y.length) {
			
			y.forEach(function(l){
				var flktyInit1 = new Flickity(l, {
	        autoPlay: false,
					pageDots: false,
					draggable: true,
	        prevNextButtons: false,
	        cellAlign: 'left',
	        percentPosition: false
				});
				
				if (l.nextElementSibling) {
					var flktyInit1 = new Flickity(l.nextElementSibling, {
		        autoPlay: false,
						pageDots: false,
						draggable: true,
		        prevNextButtons: false,
		        cellAlign: 'left',
		        percentPosition: false,
		        asNavFor: l
					});
				}
			});
			
		}
		
		var y = document.querySelector('.full-height-block__slider');
		
		if (y) {
			var j = y.parentNode.querySelector('.full-height-block__btn--left');
		  var r = y.parentNode.querySelector('.full-height-block__btn--right');
			
			var flktyInit1 = new Flickity(y, {
        autoPlay: false,
				pageDots: false,
				draggable: true,
        prevNextButtons: false,
        cellAlign: 'left',
        percentPosition: false
			});
			
			var flkty = Flickity.data(y);
	      
      flkty.on( 'change', function(index) {
        if (index == 0 && j) {
          j.disabled = true;
        } else {
          j.disabled = false;
        }

        if (index == flkty.cells.length - 1 && r) {
          r.disabled = true;
        } else {
          r.disabled = false;
        }
        
      });
      
      if (j) {
	      j.addEventListener('click', function(){
	        flkty.previous(true, false);
				});
			}

			if (r) {
				r.addEventListener('click', function(){
	        flkty.next(true, false);
				});
			}
			
		}
		
	},
	
	scrollEvent: function(){
		
		if (s.raf) {
		  window.cancelAnimationFrame(s.raf);
	  }
	  
		s.raf = window.requestAnimationFrame(LH.scrollEvent);
		LH.updateScroll();
		LH.colorChange();
		
	},
	
	updateScroll: function() {
	  s.lastScrollY = window.pageYOffset;
	  if (!s.menuOpen) {
			LH.headerScroll();
	  }
	},
	
	headerScroll: function(){
		
		if (s.lastScrollY > 240) {
			if (!s.scrolled) {
				s.ltl.to(a.headerLogoType, .325, { autoAlpha: 0, ease: 'Expo.inOut' })
				.to(a.headerLogoSvg, .325, { scale: .7625, ease: 'Expo.inOut' })
				s.scrolled = true;
			}
			
	  } else {
		  if (s.scrolled) {
			  s.ltl.to(a.headerLogoType, .325, { autoAlpha: 1, ease: 'Expo.inOut' })
			  .to(a.headerLogoSvg, .325, { scale: 1, ease: 'Expo.inOut' }, '-=.325')
			  s.scrolled = false;
		  }
	  }
	  
	},
	
	colorChange: function(){
		
		var fixed_position = 0;
	  var fixed_height = a.header.offsetHeight;
		
		document.querySelectorAll('.section--dark').forEach(function(l){
			  
		  var toCross_position = l.getBoundingClientRect().top;
		  var toCross_height = l.offsetHeight;			  
		  
		  if (fixed_position + fixed_height > toCross_position && fixed_position + fixed_height < toCross_position + toCross_height) {
		    a.header.classList.remove('header--white');
		  }
		  
	  });		
	  
	  document.querySelectorAll('.section--light').forEach(function(l){
		  
		  var toCross_position = l.getBoundingClientRect().top;
		  var toCross_height = l.offsetHeight;			  
		  
		  if (fixed_position + fixed_height > toCross_position && fixed_position + fixed_height < toCross_position + toCross_height) {
		    a.header.classList.add('header--white');
		  }
		  
	  });
		
	},
	
	overlay: function(){
		
		a.overlay.addEventListener('click', function(){
			s.overlayOpen = false;
			document.body.classList.remove('overflow-hide');
			TweenMax.to(a.overlay, .325, { autoAlpha: 0, ease: 'Expo.inOut' })
		})
		
		a.overlay.querySelector('.overlay__col').addEventListener('click', function(e){
			e.stopPropagation();
		})
		
		a.overlayClose.addEventListener('click', function(e){
			document.body.classList.remove('overflow-hide');
			TweenMax.to(a.overlay, .325, { autoAlpha: 0, ease: 'Expo.inOut' })
		})
		
		document.addEventListener('keydown', function(e){
			if (e.keyCode == 27 && s.overlayOpen) {
				document.body.classList.remove('overflow-hide');
				TweenMax.to(a.overlay, .325, { autoAlpha: 0, ease: 'Expo.inOut' })
			}
		})
		
	},
	
	videoOverlays: function(){
		
		var k = document.querySelectorAll('button.video-btn');
				
		if (k.length) {
			
			k.forEach(function(j){
				
				j.addEventListener('click', function(){
					
					s.overlayOpen = true;
					document.body.classList.add('overflow-hide');
					
					var embed = j.dataset.embed;
					
					a.overlay.querySelector('.overlay__col').innerHTML = embed;
					fitVids('.overlay--video');
					
					TweenMax.to(a.overlay, .325, { autoAlpha: 1, ease: 'Expo.inOut' })
					
				})
				
			})
			
		}
		
	},
	
	enquireOverlays: function(){
		
		var k = document.querySelector('.enquire-btn');
		
		if (k) {
			
			a.overlayEnq = document.querySelector('.overlay--enquire');
			a.overlayEnqClose = a.overlayEnq.querySelector('.overlay__close-btn');
			
			a.overlayEnq.addEventListener('click', function(){
				s.overlayOpen = false;
				document.body.classList.remove('overflow-hide');
				TweenMax.to(a.overlayEnq, .325, { autoAlpha: 0, ease: 'Expo.inOut' })
			})
			
			a.overlayEnq.querySelector('.overlay__wrap').addEventListener('click', function(e){
				e.stopPropagation();
			})
			
			a.overlayEnqClose.addEventListener('click', function(e){
				document.body.classList.remove('overflow-hide');
				TweenMax.to(a.overlayEnq, .325, { autoAlpha: 0, ease: 'Expo.inOut' })
			})
			
			document.addEventListener('keydown', function(e){
				if (e.keyCode == 27 && s.overlayOpen) {
					document.body.classList.remove('overflow-hide');
					TweenMax.to(a.overlayEnq, .325, { autoAlpha: 0, ease: 'Expo.inOut' })
				}
			})
			
			k.addEventListener('click', function(){
				s.overlayOpen = true;
				document.body.classList.add('overflow-hide');
				TweenMax.to(a.overlayEnq, .325, { autoAlpha: 1, ease: 'Expo.inOut' })
			});
		}
		
	},
	
	search: function() {
	  
    var q = document.querySelectorAll('.search-form__select-btn');
    
    if (q.length) {
	    
	    q.forEach(function(j){
		    		    
		    var ddopen = false;
		    
		    var k = j.parentNode.querySelectorAll('.search-form__field-dd-btn');
		    var r = j.parentNode.querySelector('.search-form__select');
		    
		    if (r.selectedIndex != 0) {
			    j.querySelector('span').innerHTML = j.parentNode.querySelector('[value=' + r.value + ']').innerHTML;
			    r.dataset.selected = true;
		    }
		    		    
		    j.addEventListener('click', function(){
			    
			    ddopen = !ddopen;
			    j.parentNode.classList.toggle('search-form__field--open');
			    
			    if (ddopen) {
				    TweenMax.to(j.nextElementSibling, .25, { y: 0, autoAlpha: 1, ease: 'Expo.inOut' })
			    } else {
				    TweenMax.to(j.nextElementSibling, .25, { y: '.5rem', autoAlpha: 0, ease: 'Expo.inOut' })
			    }
			    
		    })
		    
		    k.forEach(function(m){
			    
			    m.addEventListener('click', function(){
				    
				    k.forEach(function(p){
					    p.classList.remove('search-form__field-dd-btn--active')
					  });
					  
					  r.dataset.selected = true;
					  j.parentNode.classList.remove('search-form__field--error');
				    
				    this.classList.add('search-form__field-dd-btn--active')
				    
				    TweenMax.to(j.nextElementSibling, .25, { y: '.5rem', autoAlpha: 0, ease: 'Expo.inOut' })
				    ddopen = false
				    j.parentNode.classList.toggle('search-form__field--open');
				    
				    TweenMax.to(j.querySelector('span'), .25, { x: '.25rem', autoAlpha: 0, ease: 'Expo.inOut', onComplete: function(){
					    j.querySelector('span').innerHTML = m.innerHTML;
					    r.value = m.dataset.value;
				    } })
				    TweenMax.to(j.querySelector('span'), .25, { delay: .25, x: 0, autoAlpha: 1, ease: 'Expo.inOut' })
 
					});
		    
			  })
			  
			  r.addEventListener('change', function(e){
				  				  
				  j.querySelector('span').innerHTML = r.value;
				  
				  if (r.selectedIndex != '0') {
					  r.dataset.selected = true;
					  j.parentNode.classList.remove('search-form__field--error');
				  } else {
					  r.dataset.selected = false;
				  }
				  
				  k.forEach(function(m){
					  
					  if (m.dataset.value == r.value) {
						  m.classList.add('search-form__field-dd-btn--active')
					  } else {
						  m.classList.remove('search-form__field-dd-btn--active')
					  }
					  
					});
				  
			  })
		    
	    })
	    
	    var x = document.querySelector('.search-form');
	    var y = document.querySelectorAll('.search-form__select');
	    
	    x.addEventListener('submit', function(e){
		    e.preventDefault();
		    
		    var errors = false;
		    y.forEach(function(c){
			    if (c.dataset.selected == 'false') {
				    errors = true;
				    c.parentNode.classList.add('search-form__field--error');
			    }
		    })
		    
		    if (!errors) {

			    var formData = new FormData(this);
			    
			    var string = '?';
			    
			    var i = 0;
			    for(var pair of formData.entries()) {
				    i++;
				    if (i > 1) {
					    string += '&';
				    }
					  string += pair[0] + '=' + pair[1];
						
					}
							    
			    Turbolinks.visit(this.action + string);
		    
		    }
	    })
	    
    }

  },
  
  voiceFiltering: function(){
	  
	  var l = document.querySelectorAll('.voice-filter__listing-item select');
	  
	  if (l.length) {
		  
		  l.forEach(function(o){
			  o.addEventListener('change', function(){
				  if (window.location != o.value) {
					  Turbolinks.visit(o.value);
				  }
			  })			  
		  })
		  
	  }
	  
  },
  
  contactForm: function(){
	  
	  var contactForm = document.querySelector('.contact-form');
	  
	  if (contactForm) {
		  	  
		  contactForm.addEventListener('submit', function(e){
			  e.preventDefault();
			  
			  var formData = new FormData(contactForm);
			  
				contactForm.classList.remove('contact-form--sent');
			  
			  var submitBtn = contactForm.querySelector('.arrow-btn__copy');
			  
			  submitBtn.innerHTML = 'Sending';
			  
			  submitBtn.disabled = true;
				  				
				var xhr = new XMLHttpRequest();
				xhr.open('POST', script_vars.ajax_url);

				xhr.onreadystatechange = function() {
				  if (xhr.readyState>3 && xhr.status==200) {
					  
					  contactForm.classList.add('contact-form--sent');
					  contactForm.reset();
					  
					  submitBtn.innerHTML = 'Sent';
					  
					  setTimeout(function(){
						  submitBtn.disabled = false;
						  submitBtn.innerHTML = 'Send Message';
					  }, 5000);
					}
				};
				xhr.send(formData);

		  });
		  
		}
	  
  },

};

(function() {
  LH.init();
})();