<?php get_header(); ?>

<?php
	if (have_posts()) : while (have_posts()) : the_post();
		$article_banner_background = get_field('article_banner_background', get_option('page_for_posts'));
		$article_statement_copy = get_field('article_statement_copy', get_option('page_for_posts'));
?>
<section class="full-height-block full-height-block--half section--dark<?=$article_banner_background ? ' lazyimage lazyload' : ' bg-highlight'?>"<?php if ($article_banner_background) : ?> data-bg="<?=$article_banner_background['sizes']['large']?>"<?php endif; ?>>
	<div class="full-height-block__slide">
		<div class="row full-height-block__wrap copy-block type-white pad-top-sm-6 pad-btm-sm-3 pad-top-xs-4 pad-btm-xs-3">
			<div class="col col-sm-6 full-height-block__col">
				<h1><?=get_the_title()?></h1>
			</div>
		</div>
	</div>
</section>

<?php
	$article_featured_media_type = get_field('article_featured_media_type');
	$article_featured_image = get_field('article_featured_image');
	$article_featured_video_embed = get_field('article_featured_video_embed');
	$article_featured_media_band_color = get_field('article_featured_media_band_color');
	$article_content = get_field('article_content');
	
	if ($article_featured_media_band_color == 'Gold') :
		$article_featured_media_band_color_class = ' bg-mustard';
	elseif ($article_featured_media_band_color == 'Dark blue') :
		$article_featured_media_band_color_class = ' bg-blue';
	elseif ($article_featured_media_band_color == 'Blue') :
		$article_featured_media_band_color_class = ' bg-accounting';
	elseif ($article_featured_media_band_color == 'Orange') :
		$article_featured_media_band_color_class = ' bg-people';
	elseif ($article_featured_media_band_color == 'Red') :
		$article_featured_media_band_color_class = ' bg-commercial';
	elseif ($article_featured_media_band_color == 'Green') :
		$article_featured_media_band_color_class = ' bg-legal';
	elseif ($article_featured_media_band_color == 'Purple') :
		$article_featured_media_band_color_class = ' bg-support';
	elseif ($article_featured_media_band_color == 'Yellow') :
		$article_featured_media_band_color_class = ' bg-fitness';					
	endif;
?>
<article class="pad-top-sm-6 pad-btm-sm-6 pad-top-xs-3 pad-btm-xs-3 voice-single section--dark">
	<div class="row copy-block">
		<div class="col col-sm-8">
			<div class="featured-media margin-btm-sm-3 margin-btm-xs-2">
				<div class="featured-media__img">
					<?php if ($article_featured_media_type == 'Video') : ?>
					<button type="button" class="video-btn" data-embed='<?=esc_html($article_featured_video_embed)?>'><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 111.06 111.06" class="video-btn__svg" aria-label="Play icon" width="30"><g fill="none" stroke-width="2"><ellipse cx="55.53" cy="55.53" rx="51.94" ry="52.42"/><path d="M46.35 39.42l24.49 17.84-24.49 17.83z"/></g></svg></button>
					<?php endif; ?>
					<figure class="lazyimage lazyimage--img lazyload" style="padding-bottom: calc(<?=$article_featured_image['sizes']['large-height']?> / <?=$article_featured_image['sizes']['large-width']?> * 100%)">
						<img data-src="<?=$article_featured_image['sizes']['large']?>" alt="<?=$article_featured_image['alt']?>" class="lazyload lazyimage" />
					</figure>
				</div>
				<span class="featured-media__band<?=$article_featured_media_band_color_class?>" aria-hidden="true"></span>
			</div>
			<?=$article_content?>
		</div>
	
		<div class="col col-sm-4 pad-btm-xs-3 pad-btm-sm-0 first-xs last-sm">
			<div class="margin-btm-xs-1 margin-btm-sm-2">
				<h4 class="type-bold type-h5">Author</h4>
				<?php $the_author = get_the_author_meta('nickname'); ?>
				<p><?=$the_author?></p>
			</div>
			
			<h4 class="type-bold type-h5">Share</h4>
			<div>
				<a href="http://www.facebook.com/sharer.php?u=<?=get_the_permalink()?>" target="_blank" class="arrow-btn"><span class="arrow-btn__copy type-p">Facebook</span><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44.97 25.97" class="arrow-btn__svg" aria-label="Right icon" width="30"><g fill="none" stroke-width="2"><path d="M30.28 3.71L39.56 13l-9.28 9.28"/><path d="M39.56 13H4"/></g></svg></a>
			</div>
			<div>
				<a href="https://www.linkedin.com/shareArticle?url=<?=get_the_permalink()?>&title=<?=get_the_title()?>" target="_blank" class="arrow-btn"><span class="arrow-btn__copy type-p">LinkedIn</span><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44.97 25.97" class="arrow-btn__svg" aria-label="Right icon" width="30"><g fill="none" stroke-width="2"><path d="M30.28 3.71L39.56 13l-9.28 9.28"/><path d="M39.56 13H4"/></g></svg></a>
			</div>
		</div>
	</div>
	
	<?php
		$next_post = get_next_post();
		$prev_post = get_previous_post();
		if ($prev_post OR $next_post) :
	?>
	<div class="row pad-top-xs-3">
		<div class="col">
			<div class="voice-nav">
				<?php if ($prev_post) : ?>
				<a href="<?=get_the_permalink($prev_post->ID)?>" class="arrow-btn arrow-btn--back voice-nav__btn voice-nav__btn--back"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44.97 25.97" class="arrow-btn__svg" aria-label="Left icon" width="30"><g fill="none" stroke-width="2"><path d="M13.28 22.27L4 13l9.28-9.28"/><path d="M4 13h35.56"/></g></svg><span class="arrow-btn__copy type-p">Back</span></a>
				<?php endif; ?>
				<?php if ($next_post) : ?>
				<a href="<?=get_the_permalink($next_post->ID)?>" class="arrow-btn voice-nav__btn voice-nav__btn--next"><span class="arrow-btn__copy type-p">Next</span><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 44.97 25.97" class="arrow-btn__svg" aria-label="Right icon" width="30"><g fill="none" stroke-width="2"><path d="M30.28 3.71L39.56 13l-9.28 9.28"/><path d="M39.56 13H4"/></g></svg></a>
				<?php endif; ?>
			</div>
		</div>
		<?php endif; ?>
	</div>
</article>

<?php if ($article_statement_copy) : ?>
<section class="bg-highlight section--dark">
	<div class="row copy-block type-white type-center pad-top-sm-6 pad-btm-sm-6 pad-top-xs-3 pad-btm-xs-3">
		<div class="col col-sm-10 col-sm-offset-1">
			<h2><?=$article_statement_copy?></h2>
		</div>
	</div>
</section>
<?php endif; ?>

<?php endwhile; endif; ?>

<?php get_footer(); ?>